/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.simplesurvey.Survey;
import java.math.BigDecimal;

public class Poll
extends Survey {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.simplesurvey.Poll";
    public static final String FORM_SECTION = "formSection";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String RECENT_POLL = "com.arsdigita.simplesurvey.RecentPoll";

    @Override
    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Poll(DataObject dataObject) {
        super(dataObject);
    }

    public Poll(String typeName) {
        super(typeName);
    }

    public Poll() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Poll(ObjectType type) throws DataObjectNotFoundException {
        super(type);
    }

    public Poll(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Poll(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static Survey retrieve(BigDecimal id) throws DataObjectNotFoundException {
        return new Poll(id);
    }

    public static Poll getMostRecentPoll() {
        DataQuery polls = SessionManager.getSession().retrieveQuery(RECENT_POLL);
        Poll poll = null;
        if (polls.next()) {
            try {
                poll = new Poll((BigDecimal)polls.get("pollID"));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        polls.close();
        return poll;
    }
}

