/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.simplesurvey.Answer;
import com.arsdigita.simplesurvey.ResponseCollection;
import com.arsdigita.simplesurvey.Survey;
import java.math.BigDecimal;
import java.util.Date;

public class Response
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.simplesurvey.Response";
    public static final String SURVEY = "survey";
    public static final String USER = "user";
    public static final String SCORE = "score";
    public static final String ENTRY_DATE = "entryDate";
    public static final String ANSWERS = "answers";
    public static final String QUESTIONS_ANSWERED = "questionsAnswered";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Response(DataObject dataObject) {
        super(dataObject);
    }

    protected Response(String typeName) {
        super(typeName);
    }

    public Response() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected Response(ObjectType type) throws DataObjectNotFoundException {
        super(type);
    }

    protected Response(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Response(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static Response create(Survey survey, User user) {
        Response response = new Response();
        response.setup(survey, user);
        response.setScore(new BigDecimal(0));
        return response;
    }

    protected void setup(Survey survey, User user) {
        this.set(ENTRY_DATE, new Date());
        this.set("userID", user.getID());
        this.set("surveyID", survey.getID());
    }

    public static Response retrieve(DataObject obj) {
        return new Response(obj);
    }

    public static ResponseCollection retrieveBySurvey(Survey survey) {
        DataCollection responses = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        responses.addEqualsFilter("surveyID", (Object)survey.getID());
        return new ResponseCollection(responses);
    }

    public static ResponseCollection retrieveBySurvey(Survey survey, User user) {
        ResponseCollection responses = Response.retrieveBySurvey(survey);
        responses.addEqualsFilter("userID", user.getID());
        return responses;
    }

    public boolean questionsAnswered() {
        BigDecimal responseID = this.getID();
        DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.simplesurvey.questionsAnswered");
        dq.setParameter("responseID", (Object)responseID);
        dq.next();
        Boolean questionsAnswered = (Boolean)dq.get(QUESTIONS_ANSWERED);
        dq.close();
        return questionsAnswered;
    }

    public void addAnswer(PersistentLabel label, PersistentWidget widget, String value) {
        Answer answer = Answer.create(label, widget, value);
        this.add(ANSWERS, answer);
    }

    public Date getEntryDate() {
        return (Date)this.get(ENTRY_DATE);
    }

    public BigDecimal getScore() {
        return (BigDecimal)this.get(SCORE);
    }

    public void setScore(BigDecimal score) {
        this.set(SCORE, score);
    }
}

