/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.simplesurvey.Response;
import com.arsdigita.simplesurvey.ResponseCollection;
import com.arsdigita.simplesurvey.SurveyCollection;
import java.math.BigDecimal;
import java.util.Date;

public class Survey
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.simplesurvey.Survey";
    public static final String FORM_SECTION = "formSection";
    public static final String PACKAGE_INSTANCE = "packageInstance";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String RESPONSES_PUBLIC = "responsesPublic";
    public static final String QUIZ_TYPE = "quizType";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Survey(DataObject dataObject) {
        super(dataObject);
    }

    public Survey(String typeName) {
        super(typeName);
    }

    public Survey() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Survey(ObjectType type) throws DataObjectNotFoundException {
        super(type);
    }

    public Survey(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Survey(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static Survey retrieve(BigDecimal id) throws DataObjectNotFoundException {
        Survey survey = new Survey(id);
        return survey;
    }

    public static Survey retrieve(DataObject obj) {
        Survey survey = new Survey(obj);
        return survey;
    }

    public static SurveyCollection retrieveAll() {
        DataCollection surveys = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        surveys.addOrder(START_DATE);
        return new SurveyCollection(surveys);
    }

    public ResponseCollection getResponses() {
        return Response.retrieveBySurvey(this);
    }

    public ResponseCollection getUserResponses(User user) {
        return Response.retrieveBySurvey(this, user);
    }

    public boolean hasUserResponded(User user) {
        ResponseCollection responses = this.getUserResponses(user);
        if (responses.next()) {
            responses.close();
            return true;
        }
        return false;
    }

    public void setForm(PersistentForm persistentForm) {
        this.set(FORM_SECTION, persistentForm);
    }

    public PersistentForm getForm() {
        return new PersistentForm((DataObject)this.get(FORM_SECTION));
    }

    public void setStartDate(Date startDate) {
        this.set(START_DATE, startDate);
    }

    public Date getStartDate() {
        return (Date)this.get(START_DATE);
    }

    public void setEndDate(Date endDate) {
        this.set(END_DATE, endDate);
    }

    public Date getEndDate() {
        return (Date)this.get(END_DATE);
    }

    public void setQuizType(String quizType) {
        this.set(QUIZ_TYPE, quizType);
    }

    public String getQuizType() {
        return (String)this.get(QUIZ_TYPE);
    }

    public boolean responsesArePublic() {
        return (Boolean)this.get(RESPONSES_PUBLIC);
    }

    public void setResponsesPublic(Boolean responsesPublic) {
        this.set(RESPONSES_PUBLIC, responsesPublic);
    }

    public DataQuery getLabelDataQuery() {
        String queryName = "com.arsdigita.simplesurvey.GetFormLabels";
        DataQuery dataQuery = SessionManager.getSession().retrieveQuery(queryName);
        dataQuery.setParameter("surveyID", (Object)this.getID());
        return dataQuery;
    }

    public boolean isLive() {
        Date currentDate = new Date();
        return this.getStartDate().compareTo(currentDate) < 0 && this.getEndDate().compareTo(currentDate) > 0;
    }

    public static Survey getMostRecentSurvey() {
        DataCollection surveys = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        surveys.addFilter("startDate <= sysdate and endDate > sysdate");
        surveys.addOrder("startDate desc");
        Survey survey = null;
        if (surveys.next()) {
            survey = new Survey(surveys.getDataObject());
        }
        surveys.close();
        return survey;
    }
}

