/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.simplesurvey.SimpleSurveyUtil;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.ui.SurveyTable;
import com.arsdigita.simplesurvey.ui.ViewPanel;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class IndexPanel
extends SimpleContainer {
    private SegmentedPanel m_panel;
    private SurveyTable m_surveyTable;
    private SurveyTable m_pollsTable;
    private ViewPanel m_viewSurvey;
    private ViewPanel m_viewPoll;
    private Link m_adminLink;
    private BigDecimalParameter m_surveyID;
    private SurveySelectionModel m_survey;
    private static Logger s_log = Logger.getLogger((String)IndexPanel.class.getName());

    public IndexPanel(SurveySelectionModel survey, SurveySelectionModel poll) {
        this.m_survey = survey;
        this.m_viewSurvey = new ViewPanel(this.m_survey);
        this.add((Component)this.m_viewSurvey);
        this.m_panel = new SegmentedPanel();
        this.m_adminLink = new Link((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.administer")), "admin/index.jsp");
        this.add((Component)this.m_adminLink);
        Label surveyLabel = new Label(GlobalizationUtil.globalize("simplesurvey.ui.active_surveys"));
        this.m_surveyTable = new SurveyTable(Survey.class);
        this.m_surveyTable.setRowSelectionModel((SingleSelectionModel)this.m_survey);
        this.m_surveyTable.setClassAttr("dataTable");
        this.m_panel.addSegment((Component)surveyLabel, (Component)this.m_surveyTable);
        this.add((Component)this.m_panel);
    }

    public void register(Page p) {
        super.register(p);
        this.m_surveyID = new BigDecimalParameter("survey_id");
        p.addGlobalStateParam((ParameterModel)this.m_surveyID);
        p.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent e) {
                PageState ps = e.getPageState();
                BigDecimal surveyID = (BigDecimal)ps.getValue((ParameterModel)IndexPanel.this.m_surveyID);
                IndexPanel.this.m_survey.setSelectedKey(ps, surveyID);
                if (IndexPanel.this.m_survey.isSelected(ps)) {
                    IndexPanel.this.m_adminLink.setVisible(ps, false);
                    IndexPanel.this.m_viewSurvey.setVisible(ps, true);
                    IndexPanel.this.m_panel.setVisible(ps, false);
                } else {
                    IndexPanel.this.m_adminLink.setVisible(ps, SimpleSurveyUtil.isUserAdmin(ps));
                    IndexPanel.this.m_viewSurvey.setVisible(ps, false);
                    IndexPanel.this.m_panel.setVisible(ps, true);
                }
            }
        });
    }
}

