/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.web.URL;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ResultsPane
extends SimpleContainer {
    private static final String USER_ANSWER = "userAnswer";
    private static final String CORRECT_ANSWER = "correctAnswer";
    private static final String QUESTION_NUMBER = "questionNumber";
    private static final String SCORE = "score";
    private static final String SURVEY_NUMBER = "surveyNumber";
    private static final String SURVEY_PERCENTAGE = "surveyPercentage";
    private static final String ANSWER_COUNT = "answerCount";
    private static final String ANSWER_VALUE = "answerValue";
    private static final String KNOWLEDGE_TEST = "knowledge_test";
    private TableColumn m_tabulatorColumn;
    private TableColumn m_scoreColumn;
    private TableColumn m_percentColumn;
    private DataTable m_resultsTable;
    private DataTable m_statisticsTable;
    private Link m_statisticsLink;
    private Label m_assessmentSummary;
    private Label m_scoreLabel;
    private RequestLocal m_survey;
    private RequestLocal m_user;
    private RequestLocal m_response;
    private SurveySelectionModel m_surveyModel;
    private BigDecimalParameter m_responseID;
    private BigDecimalParameter m_surveyID;
    private int m_rowCount;
    private static Logger s_log = Logger.getLogger((String)ResultsPane.class.getName());

    public ResultsPane(SurveySelectionModel surveyModel, RequestLocal response) {
        this.m_surveyModel = surveyModel;
        this.m_response = response;
        this.m_survey = new RequestLocal(){

            public Object initialValue(PageState ps) {
                Survey survey = ResultsPane.this.m_surveyModel.getSelectedSurvey(ps);
                return survey;
            }
        };
        this.m_user = new RequestLocal(){

            public Object initialValue(PageState ps) {
                User user = (User)Kernel.getContext().getParty();
                return user;
            }
        };
        this.addAssessmentSummary(this);
        this.addResultsTable(this);
        this.addScoreLabel(this);
        this.addStatisticsTable(this);
        this.addStatisticsLink(this);
    }

    public void register(Page p) {
        p.setVisibleDefault((Component)this.m_statisticsTable, false);
        this.m_responseID = new BigDecimalParameter("response_id");
        this.m_surveyID = new BigDecimalParameter("survey_id");
        p.addGlobalStateParam((ParameterModel)this.m_surveyID);
        p.addGlobalStateParam((ParameterModel)this.m_responseID);
        p.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent e) {
                PageState ps = e.getPageState();
                Survey s = (Survey)((Object)ResultsPane.this.m_survey.get(ps));
                if (s == null) {
                    return;
                }
                if (s.getQuizType().equals(ResultsPane.KNOWLEDGE_TEST)) {
                    ResultsPane.this.m_resultsTable.setVisible(ps, true);
                    ResultsPane.this.m_scoreLabel.setVisible(ps, true);
                    ResultsPane.this.m_assessmentSummary.setVisible(ps, false);
                } else {
                    ResultsPane.this.m_resultsTable.setVisible(ps, false);
                    ResultsPane.this.m_scoreLabel.setVisible(ps, false);
                    ResultsPane.this.m_assessmentSummary.setVisible(ps, true);
                }
                if (!s.responsesArePublic()) {
                    ResultsPane.this.m_statisticsLink.setVisible(ps, false);
                } else if (s.responsesArePublic() && ps.getValue((ParameterModel)ResultsPane.this.m_responseID) != null) {
                    ResultsPane.this.m_statisticsTable.setVisible(ps, true);
                    ResultsPane.this.m_statisticsLink.setVisible(ps, false);
                }
            }
        });
        super.register(p);
    }

    public void addScoreLabel(SimpleContainer sc) {
        this.m_scoreLabel = new Label();
        this.m_scoreLabel.addPrintListener((PrintListener)new ScorePrintListener());
        sc.add((Component)this.m_scoreLabel);
    }

    public void addStatisticsLink(SimpleContainer sc) {
        this.m_statisticsLink = new Link((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.view_all_results")), new PrintListener(){

            public void prepare(PrintEvent e) {
                String node;
                PageState ps = e.getPageState();
                Link t = (Link)e.getTarget();
                Object responseID = null;
                String uri = ps.getRequestURI();
                if (uri.startsWith(node = URL.getDispatcherPath())) {
                    uri = uri.substring(node.length(), uri.length());
                }
                t.setTarget(uri);
                t.setVar("response_id", ResultsPane.this.getResponseID(ps).toString());
                t.setVar("survey_id", ((BigDecimal)ps.getValue((ParameterModel)ResultsPane.this.m_surveyID)).toString());
            }

            public boolean isVisible(PageState ps) {
                Survey s = (Survey)((Object)ResultsPane.this.m_survey.get(ps));
                return s.responsesArePublic() && !ResultsPane.this.m_statisticsTable.isVisible(ps);
            }
        });
        sc.add((Component)this.m_statisticsLink);
    }

    public void addStatisticsTable(SimpleContainer sc) {
        this.m_statisticsTable = new DataTable((DataQueryBuilder)new StatisticsTableBuilder());
        this.m_statisticsTable.addColumn((String)GlobalizationUtil.globalize("simplesurvey.ui.score").localize(), SCORE);
        this.m_statisticsTable.addColumn((String)GlobalizationUtil.globalize("simplesurvey.ui.number_of_surveys").localize(), SURVEY_NUMBER);
        this.m_percentColumn = this.m_statisticsTable.addColumn((String)GlobalizationUtil.globalize("simplesurvey.ui.percentage").localize(), SURVEY_PERCENTAGE, false, (TableCellRenderer)new PercentCellRenderer());
        sc.add((Component)this.m_statisticsTable);
    }

    public void addAssessmentSummary(SimpleContainer sc) {
        this.m_assessmentSummary = new Label();
        this.m_assessmentSummary.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState ps = e.getPageState();
                BigDecimal responseID = ResultsPane.this.getResponseID(ps);
                String query = "com.arsdigita.simplesurvey.getAssessmentResults";
                DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.simplesurvey.getAssessmentResults");
                dq.setParameter("responseID", (Object)responseID);
                StringBuffer sb = new StringBuffer((String)GlobalizationUtil.globalize("simplesurvey.ui.you_have_scored").localize());
                int i = 0;
                while (dq.next()) {
                    BigDecimal answerCount = (BigDecimal)dq.get(ResultsPane.ANSWER_COUNT);
                    BigDecimal answerValue = (BigDecimal)dq.get(ResultsPane.ANSWER_VALUE);
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(" ").append(answerCount.toString()).append(" ");
                    sb.append((String)GlobalizationUtil.globalize("simplesurvey.ui.answers_worth").localize());
                    sb.append(" ").append(answerValue.toString());
                    sb.append(" ").append((String)GlobalizationUtil.globalize("simplesurvey.ui.points").localize());
                    ++i;
                }
                sb.append(".");
                Label target = (Label)e.getTarget();
                target.setLabel(sb.toString());
            }
        });
        sc.add((Component)this.m_assessmentSummary);
    }

    public void addResultsTable(SimpleContainer sc) {
        this.m_resultsTable = new DataTable((DataQueryBuilder)new ResultsTableBuilder());
        this.m_resultsTable.addColumn((String)GlobalizationUtil.globalize("simplesurvey.ui.question_number").localize(), QUESTION_NUMBER);
        this.m_resultsTable.addColumn((String)GlobalizationUtil.globalize("simplesurvey.ui.user_answer").localize(), USER_ANSWER);
        this.m_resultsTable.addColumn((String)GlobalizationUtil.globalize("simplesurvey.ui.correct_answer").localize(), CORRECT_ANSWER);
        sc.add((Component)this.m_resultsTable);
    }

    private BigDecimal getResponseID(PageState ps) {
        BigDecimal responseID = null;
        responseID = this.m_response.get(ps) != null ? (BigDecimal)this.m_response.get(ps) : (BigDecimal)ps.getValue((ParameterModel)this.m_responseID);
        return responseID;
    }

    private class PercentCellRenderer
    extends DefaultTableCellRenderer {
        public PercentCellRenderer() {
            super(true);
        }

        public Component getComponent(Table table, PageState s, Object value, boolean isSelected, Object key, int row, int column) {
            return new Label(value.toString() + "%");
        }
    }

    private class ScorePrintListener
    implements PrintListener {
        private static final String USER_SCORE = "userScore";
        private static final String MAX_SCORE = "maxScore";

        public void prepare(PrintEvent e) {
            PageState ps = e.getPageState();
            Label target = (Label)e.getTarget();
            User user = (User)ResultsPane.this.m_user.get(ps);
            Survey survey = (Survey)((Object)ResultsPane.this.m_survey.get(ps));
            BigDecimal userScore = null;
            BigDecimal maxScore = null;
            BigDecimal responseID = ResultsPane.this.getResponseID(ps);
            DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.simplesurvey.getUserScore");
            dq.setParameter("responseID", (Object)responseID);
            while (dq.next()) {
                userScore = (BigDecimal)dq.get(USER_SCORE);
                maxScore = (BigDecimal)dq.get(MAX_SCORE);
            }
            dq.close();
            Object[] results = new Object[]{userScore, maxScore};
            target.setLabel(GlobalizationUtil.globalize("simplesurvey.ui.you_have_scored_out_of_a_possible", results));
        }
    }

    private class ResultsTableBuilder
    implements DataQueryBuilder {
        private static final String KEY_COLUMN = "answerID";
        public boolean m_locked;

        public DataQuery makeDataQuery(DataTable t, PageState ps) {
            BigDecimal responseID = ResultsPane.this.getResponseID(ps);
            String query = "com.arsdigita.simplesurvey.getResponseResults";
            DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.simplesurvey.getResponseResults");
            dq.setParameter("responseID", (Object)responseID);
            return dq;
        }

        public String getKeyColumn() {
            return KEY_COLUMN;
        }

        public void lock() {
            this.m_locked = true;
        }

        public boolean isLocked() {
            return this.m_locked;
        }
    }

    private class StatisticsTableBuilder
    implements DataQueryBuilder {
        private static final String KEY_COLUMN = "surveyID";
        public boolean m_locked;

        public DataQuery makeDataQuery(DataTable t, PageState ps) {
            Survey s = (Survey)((Object)ResultsPane.this.m_survey.get(ps));
            String query = "com.arsdigita.simplesurvey.getSurveyStatistics";
            DataQuery dq = SessionManager.getSession().retrieveQuery(query);
            dq.setParameter(KEY_COLUMN, (Object)s.getID());
            return dq;
        }

        public String getKeyColumn() {
            return KEY_COLUMN;
        }

        public void lock() {
            this.m_locked = true;
        }

        public boolean isLocked() {
            return this.m_locked;
        }
    }
}

