/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.simplesurvey.ui.IndexPanel;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import com.arsdigita.ui.UI;
import com.arsdigita.ui.login.UserAuthenticationListener;
import com.arsdigita.web.Application;
import javax.servlet.http.HttpServletRequest;

public abstract class SimpleSurveyPanel
extends SimpleContainer {
    protected BoxPanel m_navBar;
    private String m_title;

    protected SimpleSurveyPanel(String pageTitle) {
        this.m_title = pageTitle;
        this.addNavBar();
        this.addComponentsToPage();
    }

    public void register(Page p) {
        super.register(p);
        p.addRequestListener((RequestListener)new UserAuthenticationListener());
    }

    public String getWidgetTitle() {
        return this.m_title;
    }

    protected void addNavBar() {
        this.m_navBar = new BoxPanel(1);
        this.addParentPagesToNavbar();
        this.m_navBar.add((Component)new Label(this.getWidgetTitle()));
        this.add((Component)this.m_navBar);
    }

    protected void addParentPagesToNavbar() {
        this.addWorkspaceToNavBar();
        Link indexLink = new Link((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.simple_survey_index_page")), new PrintListener(){

            public void prepare(PrintEvent event) {
                Link link = (Link)event.getTarget();
                PageState pageState = event.getPageState();
                link.setTarget(SimpleSurveyPanel.getSubsiteURL(pageState.getRequest()) + "index.jsp");
            }
        });
        if (!((Object)((Object)this)).getClass().equals(IndexPanel.class)) {
            this.m_navBar.add((Component)indexLink);
        }
    }

    protected void addWorkspaceToNavBar() {
        this.m_navBar.add((Component)new Link("Workspace", UI.getWorkspaceURL()));
    }

    protected abstract void addComponentsToPage();

    public abstract String getRelativeURL();

    public static String getSubsiteURL(HttpServletRequest request) {
        Application thisApp = Application.getCurrentApplication((HttpServletRequest)request);
        return thisApp.getPrimaryURL();
    }
}

