/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.simplesurvey.Response;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.Question;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SurveyProcessListener
implements FormProcessListener {
    public static final String SURVEY_ID_NAME = "__ss_survey_id__";
    public static final String RESPONSE_ID = "__ss_response_id__";
    public static final BigDecimal THE_PUBLIC_USER = new BigDecimal(-200);
    private static final String KNOWLEDGE_TEST = "knowledge_test";
    protected RequestLocal m_persistentForm = new RequestLocal();
    private RequestLocal m_nameQuestionMap = new RequestLocal();
    private RequestLocal m_response;
    private static Logger s_log = Logger.getLogger((String)SurveyProcessListener.class.getName());

    public SurveyProcessListener(RequestLocal response) {
        this.m_response = response;
    }

    public SurveyProcessListener() {
        this.m_response = null;
    }

    public void process(FormSectionEvent event) {
        FormData formData = event.getFormData();
        PageState ps = event.getPageState();
        BigDecimal surveyID = (BigDecimal)formData.get((Object)SURVEY_ID_NAME);
        BigDecimal responseID = (BigDecimal)formData.get((Object)RESPONSE_ID);
        this.m_response.set(ps, (Object)responseID);
        Survey survey = (Survey)((Object)FormBuilderUtil.instantiateObjectOneArg((String)Survey.class.getName(), (Object)surveyID));
        Response response = null;
        try {
            response = (Response)DomainObjectFactory.newInstance((OID)new OID(Response.class.getName(), (Object)responseID));
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        if (response.questionsAnswered()) {
            return;
        }
        this.m_persistentForm.set(ps, (Object)survey.getForm());
        User user = (User)Kernel.getContext().getParty();
        if (user == null) {
            try {
                user = User.retrieve((BigDecimal)THE_PUBLIC_USER);
            }
            catch (DataObjectNotFoundException e) {
                s_log.error((Object)"Public User does not exist.");
            }
        }
        Iterator parameterIter = formData.getParameters().iterator();
        while (parameterIter.hasNext()) {
            s_log.warn((Object)"Found some formData");
            ParameterData parameterData = (ParameterData)parameterIter.next();
            String parameterName = (String)parameterData.getName();
            Object parameterValue = parameterData.getValue();
            if (parameterValue instanceof String[]) {
                String[] valueArray = (String[])parameterValue;
                for (int i = 0; i < valueArray.length; ++i) {
                    this.addAnswer(response, ps, valueArray[i], parameterName);
                }
                continue;
            }
            this.addAnswer(response, ps, parameterValue, parameterName);
        }
        response.save();
        this.saveScore(survey, response);
    }

    private void saveScore(Survey survey, Response response) {
        String query = survey.getQuizType().equals(KNOWLEDGE_TEST) ? "com.arsdigita.simplesurvey.saveScore" : "com.arsdigita.simplesurvey.saveAssessmentScore";
        DataOperation dao = SessionManager.getSession().retrieveDataOperation(query);
        dao.setParameter("responseID", (Object)response.getID());
        dao.execute();
    }

    private void addAnswer(Response surveyResponse, PageState ps, Object parameterValue, String parameterName) {
        s_log.debug((Object)("formData name " + parameterName + " value " + parameterValue));
        Question question = this.getQuestion(ps, parameterName);
        if (question != null) {
            PersistentLabel persistentLabel = question.getLabel();
            PersistentWidget persistentWidget = question.getWidget();
            surveyResponse.addAnswer(persistentLabel, persistentWidget, this.getStringValue(parameterValue));
        }
    }

    private String getStringValue(Object parameterValue) {
        return parameterValue == null ? "" : parameterValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Question getQuestion(PageState ps, String parameterName) {
        if (this.m_nameQuestionMap.get(ps) == null) {
            SurveyProcessListener surveyProcessListener = this;
            synchronized (surveyProcessListener) {
                HashMap<String, Question> nameQuestionMap = new HashMap<String, Question>();
                s_log.debug((Object)"initializing the parameter name persistent label map");
                PersistentForm persistentForm = (PersistentForm)this.m_persistentForm.get(ps);
                DataAssociationCursor componentCursor = persistentForm.getComponents();
                PersistentLabel lastPersistentLabel = null;
                while (componentCursor.next()) {
                    PersistentComponent factory = (PersistentComponent)DomainObjectFactory.newInstance((DataObject)componentCursor.getDataObject());
                    s_log.debug((Object)("iterating, component " + factory.toString()));
                    if (factory instanceof PersistentLabel) {
                        lastPersistentLabel = (PersistentLabel)factory;
                    }
                    if (!(factory instanceof PersistentWidget)) continue;
                    s_log.debug((Object)("adding to map " + ((PersistentWidget)factory).getParameterName() + " mapped to " + lastPersistentLabel));
                    Question question = new Question(lastPersistentLabel, (PersistentWidget)factory);
                    nameQuestionMap.put(((PersistentWidget)factory).getParameterName(), question);
                }
                this.m_nameQuestionMap.set(ps, nameQuestionMap);
            }
        }
        s_log.debug((Object)("fetching label for parameter name " + parameterName));
        Question question = (Question)((Map)this.m_nameQuestionMap.get(ps)).get(parameterName);
        s_log.debug((Object)("returning " + question));
        return question;
    }
}

