/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.persistence.Filter;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.SurveyCollection;
import com.arsdigita.simplesurvey.ui.admin.AdminSurveyTableModel;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.web.URL;
import java.util.Date;
import org.apache.log4j.Logger;

public class SurveyTable
extends Table {
    private static final Logger s_log = Logger.getLogger((String)SurveyTable.class.getName());

    public SurveyTable(Class surveyClass) {
        super((TableModelBuilder)new SurveyTableModelBuilder(surveyClass), (Object[])new String[]{""});
        this.setDefaultCellRenderer(new SurveyCellRenderer());
    }

    private class SurveyCellRenderer
    implements TableCellRenderer {
        private SurveyCellRenderer() {
        }

        public Component getComponent(Table table, PageState ps, Object value, boolean isSelected, Object key, int row, int column) {
            Survey survey = (Survey)((Object)value);
            PersistentForm form = survey.getForm();
            String adminName = form.getAdminName();
            if (column == 0) {
                String node;
                String uri = ps.getRequestURI();
                if (uri.startsWith(node = URL.getDispatcherPath())) {
                    uri = uri.substring(node.length(), uri.length());
                }
                Link l = new Link(adminName, uri);
                l.setVar("survey_id", survey.getID().toString());
                return l;
            }
            throw new RuntimeException("column out of bounds " + column);
        }
    }

    private static class SurveyTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private Class m_surveyClass;

        public SurveyTableModelBuilder(Class surveyClass) {
            this.m_surveyClass = surveyClass;
        }

        public TableModel makeModel(Table l, PageState pageState) {
            SurveyCollection surveys = Survey.retrieveAll();
            surveys.addEqualsFilter("defaultDomainClass", this.m_surveyClass.getName());
            Date currentDate = new Date();
            Filter startFilter = surveys.addFilter("startDate < :startDate");
            startFilter.set("startDate", (Object)currentDate);
            Filter endFilter = surveys.addFilter("endDate > :endDate");
            endFilter.set("endDate", (Object)currentDate);
            return new AdminSurveyTableModel(surveys);
        }
    }
}

