/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.User;
import com.arsdigita.simplesurvey.Response;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.ResultsPane;
import com.arsdigita.simplesurvey.ui.SurveyForm;
import com.arsdigita.simplesurvey.ui.SurveyProcessListener;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ViewPanel
extends SimpleContainer {
    private static final Logger s_log = Logger.getLogger((String)ViewPanel.class.getName());
    private SurveySelectionModel m_survey;
    private SurveyForm m_surveyForm;
    private Label m_notLive;
    private Label m_alreadySubmitted;
    private SimpleContainer m_confirmation;
    private BigDecimalParameter m_responseID;
    public RequestLocal m_response;
    public static final BigDecimal THE_PUBLIC_USER = new BigDecimal(-200);

    public ViewPanel(SurveySelectionModel survey) {
        this.m_survey = survey;
        this.m_response = new RequestLocal();
        this.m_notLive = new Label(GlobalizationUtil.globalize("simplesurvey.ui.this_survey_is_not_currently_active"));
        this.add((Component)this.m_notLive);
        this.m_alreadySubmitted = new Label(GlobalizationUtil.globalize("simplesurvey.ui.you_have_already_completed_this_survey"));
        this.add((Component)this.m_alreadySubmitted);
        this.m_confirmation = new SimpleContainer();
        this.m_confirmation.add((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.thankyou_for_completing_the_survey")));
        this.m_confirmation.add((Component)new ResultsPane(survey, this.m_response));
        this.add((Component)this.m_confirmation);
        this.m_surveyForm = new SurveyForm(this.m_survey, this.m_response);
        this.m_surveyForm.addProcessListener(new SurveyProcessListener(this.m_response));
        this.add((Component)this.m_surveyForm);
    }

    public void register(Page p) {
        p.setVisibleDefault((Component)this.m_surveyForm, false);
        this.m_responseID = new BigDecimalParameter("response_id");
        p.addGlobalStateParam((ParameterModel)this.m_responseID);
        p.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent e) {
                BigDecimal responseID;
                PageState ps = e.getPageState();
                Survey survey = ViewPanel.this.m_survey.getSelectedSurvey(ps);
                if (survey == null) {
                    return;
                }
                if (!survey.isLive()) {
                    ViewPanel.this.m_confirmation.setVisible(ps, false);
                    ViewPanel.this.m_surveyForm.setVisible(ps, false);
                    ViewPanel.this.m_notLive.setVisible(ps, true);
                    ViewPanel.this.m_alreadySubmitted.setVisible(ps, false);
                }
                if ((responseID = (BigDecimal)ps.getValue((ParameterModel)ViewPanel.this.m_responseID)) == null) {
                    User user = (User)Kernel.getContext().getParty();
                    if (user == null) {
                        try {
                            user = User.retrieve((BigDecimal)THE_PUBLIC_USER);
                        }
                        catch (DataObjectNotFoundException err) {
                            // empty catch block
                        }
                    }
                    Response r = Response.create(survey, user);
                    ViewPanel.this.m_response.set(ps, (Object)r.getID());
                    if (ViewPanel.this.m_surveyForm.getFormData(ps).isSubmission()) {
                        ViewPanel.this.m_confirmation.setVisible(ps, true);
                        ViewPanel.this.m_surveyForm.setVisible(ps, false);
                        ViewPanel.this.m_notLive.setVisible(ps, false);
                        ViewPanel.this.m_alreadySubmitted.setVisible(ps, false);
                    } else {
                        r.save();
                        ViewPanel.this.m_confirmation.setVisible(ps, false);
                        ViewPanel.this.m_surveyForm.setVisible(ps, true);
                        ViewPanel.this.m_notLive.setVisible(ps, false);
                        ViewPanel.this.m_alreadySubmitted.setVisible(ps, false);
                    }
                } else {
                    ViewPanel.this.m_confirmation.setVisible(ps, true);
                    ViewPanel.this.m_surveyForm.setVisible(ps, false);
                    ViewPanel.this.m_notLive.setVisible(ps, false);
                    ViewPanel.this.m_alreadySubmitted.setVisible(ps, false);
                }
            }
        });
    }
}

