/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.PersistentDate;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.ui.ControlEditor;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.Question;
import com.arsdigita.simplesurvey.ui.SurveyForm;
import com.arsdigita.simplesurvey.ui.SurveyProcessListener;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.ui.admin.AnswerValuesPanel;
import com.arsdigita.simplesurvey.ui.admin.FormSelectionModel;
import com.arsdigita.simplesurvey.ui.admin.PropertiesForm;
import com.arsdigita.simplesurvey.ui.admin.ReportPanel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class AdminPanel
extends SimpleContainer {
    public static final String MODE_VIEW = "view";
    public static final String MODE_RESPONSES = "responses";
    public static final String MODE_PROPERTIES = "properties";
    public static final String MODE_WIDGETS = "widgets";
    public static final String MODE_CORRECT_ANSWERS = "correctAnswers";
    public static final String MODE_ANSWER_VALUES = "answerValues";
    private static Logger s_log = Logger.getLogger((String)AdminPanel.class.getName());
    private SurveySelectionModel m_survey;
    private SurveyForm m_view;
    private ControlEditor m_controls;
    private PropertiesForm m_props;
    private ReportPanel m_reports;
    private SurveyForm m_correctAnswerView;
    private AnswerValuesPanel m_answerValuesPanel;
    private FormSelectionModel m_form;

    public AdminPanel(SurveySelectionModel survey, Class type) {
        this.m_survey = survey;
        this.m_form = new FormSelectionModel(this.m_survey);
        this.m_view = new SurveyForm(this.m_survey, null);
        this.m_view.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                AdminPanel.this.fireCompletionEvent(e.getPageState());
            }
        });
        this.m_correctAnswerView = new SurveyForm(this.m_survey, null);
        this.m_correctAnswerView.addInitListener(new CorrectAnswersInitListener());
        this.m_correctAnswerView.addProcessListener(new CorrectAnswersProcessListener());
        this.m_answerValuesPanel = new AnswerValuesPanel(this.m_survey);
        this.m_controls = new ControlEditor(type.equals(Survey.class) ? "Survey" : "Poll", (SingleSelectionModel)this.m_form);
        Form form = new Form("controlComplete");
        form.add((Component)new Submit("Done editing"));
        form.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                AdminPanel.this.fireCompletionEvent(e.getPageState());
            }
        });
        this.m_controls.add((Component)form);
        this.m_reports = new ReportPanel(this.m_survey);
        this.m_reports.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminPanel.this.fireCompletionEvent(e.getPageState());
            }
        });
        this.m_props = new PropertiesForm(this.m_survey, type);
        this.m_props.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                AdminPanel.this.fireCompletionEvent(e.getPageState());
            }
        });
        this.add((Component)this.m_view);
        this.add((Component)this.m_correctAnswerView);
        this.add((Component)this.m_answerValuesPanel);
        this.add((Component)this.m_controls);
        this.add((Component)this.m_props);
        this.add((Component)this.m_reports);
    }

    public void setDisplayMode(PageState state, String mode) {
        if (MODE_VIEW.equals(mode)) {
            this.m_view.setVisible(state, true);
            this.m_correctAnswerView.setVisible(state, false);
            this.m_controls.setVisible(state, false);
            this.m_props.setVisible(state, false);
            this.m_reports.setVisible(state, false);
            this.m_answerValuesPanel.setVisible(state, false);
        } else if (MODE_RESPONSES.equals(mode)) {
            this.m_view.setVisible(state, false);
            this.m_correctAnswerView.setVisible(state, false);
            this.m_controls.setVisible(state, false);
            this.m_props.setVisible(state, false);
            this.m_reports.setVisible(state, true);
            this.m_answerValuesPanel.setVisible(state, false);
        } else if (MODE_CORRECT_ANSWERS.equals(mode)) {
            this.m_view.setVisible(state, false);
            this.m_correctAnswerView.setVisible(state, true);
            this.m_controls.setVisible(state, false);
            this.m_props.setVisible(state, false);
            this.m_reports.setVisible(state, false);
            this.m_answerValuesPanel.setVisible(state, false);
        } else if (MODE_PROPERTIES.equals(mode)) {
            this.m_view.setVisible(state, false);
            this.m_correctAnswerView.setVisible(state, false);
            this.m_controls.setVisible(state, false);
            this.m_props.setVisible(state, true);
            this.m_reports.setVisible(state, false);
            this.m_answerValuesPanel.setVisible(state, false);
        } else if (MODE_WIDGETS.equals(mode)) {
            this.m_view.setVisible(state, false);
            this.m_correctAnswerView.setVisible(state, false);
            this.m_controls.setVisible(state, true);
            this.m_props.setVisible(state, false);
            this.m_reports.setVisible(state, false);
            this.m_answerValuesPanel.setVisible(state, false);
        } else if (MODE_ANSWER_VALUES.equals(mode)) {
            this.m_view.setVisible(state, false);
            this.m_correctAnswerView.setVisible(state, false);
            this.m_controls.setVisible(state, false);
            this.m_props.setVisible(state, false);
            this.m_reports.setVisible(state, false);
            this.m_answerValuesPanel.setVisible(state, true);
        }
    }

    private class CorrectAnswersProcessListener
    extends SurveyProcessListener {
        private CorrectAnswersProcessListener() {
        }

        @Override
        public void process(FormSectionEvent event) {
            FormData formData = event.getFormData();
            PageState pageState = event.getPageState();
            BigDecimal surveyID = (BigDecimal)formData.get((Object)"__ss_survey_id__");
            Survey survey = (Survey)((Object)FormBuilderUtil.instantiateObjectOneArg((String)Survey.class.getName(), (Object)surveyID));
            this.m_persistentForm.set(pageState, (Object)survey.getForm());
            for (ParameterData parameterData : formData.getParameters()) {
                String parameterName = (String)parameterData.getName();
                Object parameterValue = parameterData.getValue();
                if (parameterValue instanceof String[]) {
                    String[] valueArray = (String[])parameterValue;
                    for (int i = 0; i < valueArray.length; ++i) {
                        this.addCorrectAnswer(pageState, valueArray[i], parameterName);
                    }
                    continue;
                }
                this.addCorrectAnswer(pageState, parameterValue, parameterName);
            }
            AdminPanel.this.fireCompletionEvent(event.getPageState());
        }

        private void addCorrectAnswer(PageState ps, Object parameterValue, String parameterName) {
            Question question = this.getQuestion(ps, parameterName);
            if (question != null && parameterValue != null && parameterValue != "") {
                BigDecimal widgetID;
                PersistentLabel persistentLabel = question.getLabel();
                PersistentWidget persistentWidget = question.getWidget();
                BigDecimal labelID = persistentLabel.getID();
                DataOperation dao = this.correctAnswerExists(labelID, widgetID = persistentWidget.getID()) ? SessionManager.getSession().retrieveDataOperation("com.arsdigita.simplesurvey.updateCorrectAnswer") : SessionManager.getSession().retrieveDataOperation("com.arsdigita.simplesurvey.insertCorrectAnswer");
                dao.setParameter("labelID", (Object)labelID);
                dao.setParameter("widgetID", (Object)widgetID);
                dao.setParameter("value", (Object)parameterValue.toString());
                dao.execute();
            }
        }

        private boolean correctAnswerExists(BigDecimal labelID, BigDecimal widgetID) {
            DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.simplesurvey.correctAnswerExists");
            dq.setParameter("labelID", (Object)labelID);
            dq.setParameter("widgetID", (Object)widgetID);
            if (dq.next()) {
                dq.close();
                return true;
            }
            dq.close();
            return false;
        }
    }

    private class CorrectAnswersInitListener
    implements FormInitListener {
        private static final String ANSWER_VALUE = "answerValue";
        private static final String WIDGET_ID = "widgetID";
        private static final String PARAMETER_NAME = "parameterName";
        private static final String PARAMETER_MODEL = "parameterModel";
        private static final String DOMAIN_CLASS = "domainClass";

        private CorrectAnswersInitListener() {
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState ps = e.getPageState();
            FormData fd = e.getFormData();
            BigDecimal surveyID = AdminPanel.this.m_survey.getSelectedSurvey(ps).getID();
            DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.simplesurvey.getCorrectAnswers");
            dq.setParameter("surveyID", (Object)surveyID);
            String answerValue = null;
            String parameterName = null;
            String parameterModel = null;
            String domainClass = null;
            BigInteger widgetID = null;
            Object pw = null;
            while (dq.next()) {
                answerValue = (String)dq.get(ANSWER_VALUE);
                widgetID = (BigInteger)dq.get(WIDGET_ID);
                parameterName = (String)dq.get(PARAMETER_NAME);
                parameterModel = (String)dq.get(PARAMETER_MODEL);
                domainClass = (String)dq.get(DOMAIN_CLASS);
                if (domainClass.equals("com.arsdigita.formbuilder.PersistentDate")) {
                    try {
                        PersistentDate pd = (PersistentDate)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.formbuilder.Widget", widgetID.intValue()));
                    }
                    catch (DataObjectNotFoundException ex) {
                        // empty catch block
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd hh:mm:ss zzz yyyy");
                    try {
                        Date d = sdf.parse(answerValue);
                        fd.put((Object)parameterName, (Object)d);
                    }
                    catch (ParseException ex) {}
                    continue;
                }
                fd.put((Object)parameterName, (Object)answerValue);
            }
            dq.close();
        }
    }
}

