/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.SurveyCollection;
import com.arsdigita.simplesurvey.ui.admin.AdminSurveyTableModel;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import org.apache.log4j.Logger;

public class AdminSurveyTable
extends Table {
    private static final Logger s_log = Logger.getLogger((String)AdminSurveyTable.class.getName());
    private Class m_surveyClass;
    public static final int COL_VIEW = 0;
    public static final int COL_STATUS = 1;
    public static final int COL_RESPONSES = 2;
    public static final int COL_CORRECT_ANSWERS = 3;
    public static final int COL_ANSWER_VALUES = 4;
    public static final int COL_WIDGETS = 5;
    public static final int COL_PROPERTIES = 6;
    public static final int COL_DELETE = 7;

    public AdminSurveyTable(Class surveyClass) {
        super((TableModelBuilder)new AdminSurveyTableModelBuilder(surveyClass), (Object[])new String[]{"", "", "", "", "", "", "", ""});
        this.m_surveyClass = surveyClass;
        this.setDefaultCellRenderer(new AdminSurveyTableCellRenderer());
    }

    private static class AdminSurveyTableCellRenderer
    implements TableCellRenderer {
        private AdminSurveyTableCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Survey survey = (Survey)((Object)value);
            PersistentForm form = survey.getForm();
            String adminName = form.getAdminName();
            if (column == 0) {
                return new ControlLink(adminName);
            }
            if (column == 1) {
                Label liveLabel = null;
                if (survey.isLive()) {
                    liveLabel = new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.active"));
                    liveLabel.setClassAttr("strong");
                } else {
                    liveLabel = new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.inactive"));
                }
                return liveLabel;
            }
            if (column == 2) {
                return new ControlLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.view_responses").localize());
            }
            if (column == 3) {
                return new ControlLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.set_correct_answers").localize());
            }
            if (column == 4) {
                return new ControlLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.set_answer_values").localize());
            }
            if (column == 5) {
                return new ControlLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.edit_controls").localize());
            }
            if (column == 6) {
                return new ControlLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.edit_properties").localize());
            }
            if (column == 7) {
                ControlLink link = new ControlLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.delete").localize());
                link.setConfirmation("Delete this survey");
                return link;
            }
            throw new RuntimeException("Unexpected column " + column);
        }
    }

    private static class AdminSurveyTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private Class m_surveyClass;

        public AdminSurveyTableModelBuilder(Class surveyClass) {
            this.m_surveyClass = surveyClass;
        }

        public TableModel makeModel(Table l, PageState pageState) {
            SurveyCollection surveys = Survey.retrieveAll();
            surveys.addEqualsFilter("defaultDomainClass", this.m_surveyClass.getName());
            return new AdminSurveyTableModel(surveys);
        }
    }
}

