/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class AnswerValuesPanel
extends SimpleContainer {
    private SurveySelectionModel m_survey;
    private static final String QUESTION_TEXT = "questionText";
    private static final String ANSWER_TEXT = "answerText";
    private static final String ANSWER_VALUE = "answerValue";
    private RequestLocal m_answerText;
    private RequestLocal m_questionText;
    private RequestLocal m_answerValue;
    private Form m_answerValuesForm;
    private SingleSelect m_select;
    private BigDecimalParameter m_optionID;
    private BigDecimalParameter m_surveyID;
    private ActionLink m_complete;
    private Link m_back;
    private static Logger s_log = Logger.getLogger((String)AnswerValuesPanel.class.getName());
    private DataTable m_answerTable;

    public AnswerValuesPanel(SurveySelectionModel survey) {
        this.m_survey = survey;
        this.m_answerText = new RequestLocal();
        this.m_questionText = new RequestLocal();
        this.m_answerValue = new RequestLocal();
        this.m_complete = new ActionLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.back_to_question_list").localize());
        this.m_complete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                AnswerValuesPanel.this.m_answerTable.setVisible(ps, true);
                AnswerValuesPanel.this.m_answerValuesForm.setVisible(ps, false);
                AnswerValuesPanel.this.m_complete.setVisible(ps, false);
                AnswerValuesPanel.this.m_back.setVisible(ps, true);
            }
        });
        this.m_back = new Link((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.back_to_survey_list")), "../admin");
        this.add((Component)this.m_complete);
        this.add((Component)this.m_back);
        this.setupAnswerTable();
        this.setupAnswerValuesForm();
    }

    public void register(Page p) {
        p.setVisibleDefault((Component)this.m_answerValuesForm, false);
        this.m_optionID = new BigDecimalParameter("option_id");
        this.m_surveyID = new BigDecimalParameter("survey_id");
        p.addGlobalStateParam((ParameterModel)this.m_optionID);
        p.addGlobalStateParam((ParameterModel)this.m_surveyID);
        p.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent e) {
                PageState ps = e.getPageState();
                if (ps.getValue((ParameterModel)AnswerValuesPanel.this.m_optionID) == null || AnswerValuesPanel.this.m_answerValuesForm.getFormData(ps).isSubmission()) {
                    AnswerValuesPanel.this.m_answerTable.setVisible(ps, true);
                    AnswerValuesPanel.this.m_answerValuesForm.setVisible(ps, false);
                    AnswerValuesPanel.this.m_complete.setVisible(ps, false);
                    AnswerValuesPanel.this.m_back.setVisible(ps, true);
                }
            }
        });
    }

    private String getQuestionText(PageState ps) {
        String s = (String)this.m_questionText.get(ps);
        return s.substring(6, s.length());
    }

    private String getAnswerText(PageState ps) {
        String s = (String)this.m_answerText.get(ps);
        return s;
    }

    private BigDecimal getAnswerValue(PageState ps) {
        BigDecimal bi = (BigDecimal)this.m_answerValue.get(ps);
        return bi;
    }

    private void setupAnswerTable() {
        this.m_answerTable = new DataTable((DataQueryBuilder)new AnswerListingBuilder());
        TableColumn c1 = this.m_answerTable.addColumn("simplesurvey.ui.admin.question", QUESTION_TEXT, false, (TableCellRenderer)new QuestionTextRenderer());
        TableColumn c2 = this.m_answerTable.addColumn("simplesurvey.ui.admin.answer", ANSWER_TEXT);
        TableColumn c3 = this.m_answerTable.addColumn("simplesurvey.ui.admin.current_value", ANSWER_VALUE);
        c1.setHeaderRenderer((TableCellRenderer)new GlobalizedHeaderRenderer());
        c2.setHeaderRenderer((TableCellRenderer)new GlobalizedHeaderRenderer());
        c3.setHeaderRenderer((TableCellRenderer)new GlobalizedHeaderRenderer());
        TableColumn editValueColumn = new TableColumn();
        editValueColumn.setCellRenderer((TableCellRenderer)new EditLinkRenderer());
        this.m_answerTable.getColumnModel().add(editValueColumn);
        this.m_answerTable.addTableActionListener((TableActionListener)new AnswerValueActionListener());
        this.add((Component)this.m_answerTable);
    }

    private BigDecimal getSurveyID(PageState ps) {
        BigDecimal surveyID = null;
        if (ps.getValue((ParameterModel)this.m_surveyID) == null) {
            Survey s = this.m_survey.getSelectedSurvey(ps);
            surveyID = s.getID();
        } else {
            surveyID = (BigDecimal)ps.getValue((ParameterModel)this.m_surveyID);
        }
        return surveyID;
    }

    private void setupAnswerValuesForm() {
        this.m_answerValuesForm = new AnswerValuesForm();
        this.add((Component)this.m_answerValuesForm);
    }

    private class AnswerListingBuilder
    implements DataQueryBuilder {
        private static final String KEY_COLUMN = "optionID";
        public boolean m_locked;

        public DataQuery makeDataQuery(DataTable t, PageState ps) {
            String query = "com.arsdigita.simplesurvey.getAnswerOptions";
            DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.simplesurvey.getAnswerOptions");
            dq.setParameter("surveyID", (Object)AnswerValuesPanel.this.getSurveyID(ps));
            return dq;
        }

        public String getKeyColumn() {
            return KEY_COLUMN;
        }

        public void lock() {
            this.m_locked = true;
        }

        public boolean isLocked() {
            return this.m_locked;
        }
    }

    private class EditLinkRenderer
    implements TableCellRenderer {
        private EditLinkRenderer() {
        }

        public Component getComponent(Table table, PageState ps, Object value, boolean isSelected, Object key, int row, int column) {
            if (!AnswerValuesPanel.this.isLocked() && table != null && table.isLocked()) {
                AnswerValuesPanel.this.lock();
            }
            if (value == null) {
                return new Label("");
            }
            ControlLink cl = new ControlLink((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.edit_value")));
            return cl;
        }
    }

    private class QuestionTextRenderer
    implements TableCellRenderer {
        private QuestionTextRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (!AnswerValuesPanel.this.isLocked() && table != null && table.isLocked()) {
                AnswerValuesPanel.this.lock();
            }
            if (value == null) {
                return new Label("");
            }
            String question = (String)value;
            return new Label(question.substring(6, question.length()));
        }
    }

    private class GlobalizedHeaderRenderer
    implements TableCellRenderer {
        private GlobalizedHeaderRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Label label = new Label(GlobalizationUtil.globalize((String)value));
            label.setVerticalAlignment(2);
            return label;
        }
    }

    private class AnswerValuesInitListener
    implements FormInitListener {
        private AnswerValuesInitListener() {
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState ps = e.getPageState();
            s_log.warn((Object)("Setting value of select to " + AnswerValuesPanel.this.getAnswerValue(ps)));
            AnswerValuesPanel.this.m_select.setValue(ps, (Object)AnswerValuesPanel.this.getAnswerValue(ps));
        }
    }

    private class AnswerValuesProcessListener
    implements FormProcessListener {
        private AnswerValuesProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState ps = e.getPageState();
            FormData fd = e.getFormData();
            BigDecimal optionID = (BigDecimal)ps.getValue((ParameterModel)AnswerValuesPanel.this.m_optionID);
            BigDecimal answerValue = new BigDecimal((String)fd.get((Object)AnswerValuesPanel.ANSWER_VALUE));
            DataOperation dao = SessionManager.getSession().retrieveDataOperation("com.arsdigita.simplesurvey.updateAnswerValue");
            dao.setParameter("optionID", (Object)optionID);
            dao.setParameter(AnswerValuesPanel.ANSWER_VALUE, (Object)answerValue);
            dao.execute();
            ps.setValue((ParameterModel)AnswerValuesPanel.this.m_optionID, null);
        }
    }

    private class AnswerValuesForm
    extends Form {
        private AnswerValuesForm() {
            super("answerValuesForm");
            Label questionText = new Label(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState ps = e.getPageState();
                    Label target = (Label)e.getTarget();
                    target.setLabel(AnswerValuesPanel.this.getQuestionText(ps));
                }
            });
            Label answerText = new Label(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState ps = e.getPageState();
                    Label target = (Label)e.getTarget();
                    target.setLabel(AnswerValuesPanel.this.getAnswerText(ps));
                }
            });
            this.add((Component)questionText);
            this.add((Component)answerText);
            AnswerValuesPanel.this.m_select = new SingleSelect(AnswerValuesPanel.ANSWER_VALUE);
            AnswerValuesPanel.this.m_select.addOption(new Option("0", (Component)new Label("0")));
            AnswerValuesPanel.this.m_select.addOption(new Option("1", (Component)new Label("1")));
            AnswerValuesPanel.this.m_select.addOption(new Option("2", (Component)new Label("2")));
            AnswerValuesPanel.this.m_select.addOption(new Option("3", (Component)new Label("3")));
            AnswerValuesPanel.this.m_select.addOption(new Option("4", (Component)new Label("4")));
            AnswerValuesPanel.this.m_select.addOption(new Option("5", (Component)new Label("5")));
            AnswerValuesPanel.this.m_select.addOption(new Option("6", (Component)new Label("6")));
            AnswerValuesPanel.this.m_select.addOption(new Option("7", (Component)new Label("7")));
            AnswerValuesPanel.this.m_select.addOption(new Option("8", (Component)new Label("8")));
            AnswerValuesPanel.this.m_select.addOption(new Option("9", (Component)new Label("9")));
            AnswerValuesPanel.this.m_select.addOption(new Option("10", (Component)new Label("10")));
            this.add((Component)AnswerValuesPanel.this.m_select);
            this.add((Component)new Submit(GlobalizationUtil.globalize("simplesurvey.ui.admin.submit")));
            this.addProcessListener(new AnswerValuesProcessListener());
            this.addInitListener(new AnswerValuesInitListener());
        }
    }

    private class AnswerValueActionListener
    extends TableActionAdapter {
        private AnswerValueActionListener() {
        }

        public void cellSelected(TableActionEvent e) {
            PageState ps = e.getPageState();
            ps.setValue((ParameterModel)AnswerValuesPanel.this.m_optionID, (Object)new BigDecimal(e.getRowKey().toString()));
            AnswerValuesPanel.this.m_answerTable.setVisible(ps, false);
            AnswerValuesPanel.this.m_back.setVisible(ps, false);
            AnswerValuesPanel.this.m_complete.setVisible(ps, true);
            AnswerValuesPanel.this.m_answerValuesForm.setVisible(ps, true);
            BigDecimal optionID = (BigDecimal)ps.getValue((ParameterModel)AnswerValuesPanel.this.m_optionID);
            String query = "com.arsdigita.simplesurvey.getAnswerOption";
            DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.simplesurvey.getAnswerOption");
            dq.setParameter("optionID", (Object)optionID);
            if (dq.next()) {
                AnswerValuesPanel.this.m_questionText.set(ps, (Object)((String)dq.get(AnswerValuesPanel.QUESTION_TEXT)));
                AnswerValuesPanel.this.m_answerText.set(ps, (Object)((String)dq.get(AnswerValuesPanel.ANSWER_TEXT)));
                AnswerValuesPanel.this.m_answerValue.set(ps, (Object)((BigDecimal)dq.get(AnswerValuesPanel.ANSWER_VALUE)));
                AnswerValuesPanel.this.m_select.setValue(ps, (Object)AnswerValuesPanel.this.getAnswerValue(ps));
            }
            dq.close();
        }
    }
}

