/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.ui.admin.ReportPanel;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CSVFilePanel
extends SimpleContainer {
    private static final Logger s_log = Logger.getLogger((String)CSVFilePanel.class.getName());
    private SurveySelectionModel m_survey;

    public CSVFilePanel(SurveySelectionModel survey) {
        this.m_survey = survey;
        this.setIdAttr("csvPage");
        Label csvLabel = new Label("");
        csvLabel.setIdAttr("csvFile");
        csvLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState pageState = event.getPageState();
                Label label = (Label)event.getTarget();
                label.setLabel(CSVFilePanel.this.getCSVContent(pageState), pageState);
            }
        });
        this.add((Component)csvLabel);
    }

    private String getCSVContent(PageState state) {
        int i;
        StringBuffer buffer = new StringBuffer();
        HashMap<BigDecimal, Integer> labelColumnMap = new HashMap<BigDecimal, Integer>();
        Survey survey = this.m_survey.getSelectedSurvey(state);
        DataQuery labelQuery = survey.getLabelDataQuery();
        boolean hasNext = labelQuery.next();
        int columnNumber = 0;
        while (hasNext) {
            String attributeString = (String)labelQuery.get("attributeString");
            String question = ReportPanel.getLabelAttribute(attributeString);
            BigDecimal labelID = (BigDecimal)labelQuery.get("labelID");
            buffer.append(question);
            hasNext = labelQuery.next();
            if (hasNext) {
                buffer.append(", ");
            }
            s_log.debug((Object)("adding labelID " + labelID + " with column number " + columnNumber));
            labelColumnMap.put(labelID, new Integer(columnNumber));
            ++columnNumber;
        }
        buffer.append("\n");
        String queryName = "com.arsdigita.simplesurvey.GetAllAnswers";
        DataQuery answerQuery = SessionManager.getSession().retrieveQuery(queryName);
        answerQuery.setParameter("surveyID", (Object)survey.getID());
        BigDecimal previousResponseID = null;
        String[] rowAnswers = new String[labelColumnMap.keySet().size()];
        for (i = 0; i < rowAnswers.length; ++i) {
            rowAnswers[i] = "";
        }
        while (answerQuery.next()) {
            String answer = (String)answerQuery.get("answerValue");
            if (answer == null || answer.equals("null")) {
                answer = "";
            }
            BigDecimal responseID = (BigDecimal)answerQuery.get("responseID");
            BigDecimal labelID = (BigDecimal)answerQuery.get("labelID");
            if (previousResponseID != null && !responseID.equals(previousResponseID)) {
                int i2;
                buffer.append(rowAnswers[0]);
                for (i2 = 1; i2 < rowAnswers.length; ++i2) {
                    buffer.append(", ");
                    buffer.append(rowAnswers[i2]);
                }
                buffer.append("\n");
                for (i2 = 0; i2 < rowAnswers.length; ++i2) {
                    rowAnswers[i2] = "";
                }
                columnNumber = (Integer)labelColumnMap.get(labelID);
                s_log.debug((Object)("adding labelID " + labelID + " to column " + columnNumber));
                rowAnswers[columnNumber] = answer;
            } else if (previousResponseID == null || responseID.equals(previousResponseID)) {
                columnNumber = (Integer)labelColumnMap.get(labelID);
                s_log.debug((Object)("adding labelID " + labelID + " to column " + columnNumber));
                rowAnswers[columnNumber] = rowAnswers[columnNumber].equals("") ? answer : rowAnswers[columnNumber] + " | " + answer;
            }
            previousResponseID = responseID;
        }
        if (rowAnswers.length > 0) {
            buffer.append(rowAnswers[0]);
            for (i = 1; i < rowAnswers.length; ++i) {
                buffer.append(", ");
                buffer.append(rowAnswers[i]);
            }
        }
        return buffer.toString();
    }
}

