/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.ui.admin.AdminPanel;
import com.arsdigita.simplesurvey.ui.admin.AdminSurveyTable;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class IndexPanel
extends SimpleContainer {
    private SegmentedPanel m_panel;
    private AdminSurveyTable m_surveyTable;
    private AdminPanel m_adminSurvey;
    private SurveySelectionModel m_survey;
    private BigDecimalParameter m_surveyID;
    private ActionLink m_newSurvey;
    private static Logger s_log = Logger.getLogger((String)IndexPanel.class.getName());

    public IndexPanel(SurveySelectionModel survey, SurveySelectionModel poll) {
        this.m_survey = survey;
        this.m_adminSurvey = new AdminPanel(this.m_survey, Survey.class);
        this.m_adminSurvey.addCompletionListener(new ResetVisibilityListener(this.m_survey));
        this.add((Component)this.m_adminSurvey);
        this.m_newSurvey = new ActionLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.add_new_survey").localize());
        this.m_newSurvey.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                IndexPanel.this.m_survey.clearSelection(state);
                IndexPanel.this.m_adminSurvey.setDisplayMode(state, "properties");
                IndexPanel.this.m_adminSurvey.setVisible(state, true);
                IndexPanel.this.m_panel.setVisible(state, false);
            }
        });
        this.m_panel = new SegmentedPanel();
        Label surveyLabel = new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.surveys"));
        this.m_surveyTable = new AdminSurveyTable(Survey.class);
        this.m_surveyTable.setClassAttr("dataTable");
        this.m_surveyTable.addTableActionListener(new SurveyActionListener(this.m_survey, this.m_adminSurvey));
        SegmentedPanel.Segment surveySegment = this.m_panel.addSegment((Component)surveyLabel, (Component)this.m_newSurvey);
        surveySegment.add((Component)this.m_surveyTable);
        this.add((Component)this.m_panel);
    }

    public void register(Page p) {
        super.register(p);
        this.m_surveyID = new BigDecimalParameter("survey_id");
        p.setVisibleDefault((Component)this.m_adminSurvey, false);
        p.setVisibleDefault((Component)this.m_panel, true);
        p.addGlobalStateParam((ParameterModel)this.m_surveyID);
        p.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent e) {
                PageState ps = e.getPageState();
                if (ps.getValue((ParameterModel)IndexPanel.this.m_surveyID) != null) {
                    BigDecimal surveyID = (BigDecimal)ps.getValue((ParameterModel)IndexPanel.this.m_surveyID);
                    IndexPanel.this.m_survey.setSelectedKey(ps, surveyID);
                }
            }
        });
    }

    public void generateXML(PageState state, Element parent) {
        if (this.m_survey.isSelected(state)) {
            this.m_adminSurvey.setVisible(state, true);
            this.m_panel.setVisible(state, false);
        }
        super.generateXML(state, parent);
    }

    private class ResetVisibilityListener
    implements ActionListener {
        SurveySelectionModel m_survey;

        public ResetVisibilityListener(SurveySelectionModel survey) {
            this.m_survey = survey;
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            IndexPanel.this.m_adminSurvey.setVisible(state, false);
            IndexPanel.this.m_panel.setVisible(state, true);
            this.m_survey.clearSelection(state);
        }
    }

    private class SurveyActionListener
    implements TableActionListener {
        private SurveySelectionModel m_survey;
        private AdminPanel m_admin;

        public SurveyActionListener(SurveySelectionModel survey, AdminPanel admin) {
            this.m_survey = survey;
            this.m_admin = admin;
        }

        public void cellSelected(TableActionEvent e) {
            PageState state = e.getPageState();
            int column = e.getColumn();
            String key = (String)e.getRowKey();
            BigDecimal id = new BigDecimal(key);
            this.m_survey.setSelectedKey(state, id);
            if (column == 0) {
                this.m_admin.setDisplayMode(state, "view");
            } else if (column == 2) {
                this.m_admin.setDisplayMode(state, "responses");
            } else if (column == 3) {
                this.m_admin.setDisplayMode(state, "correctAnswers");
            } else if (column == 5) {
                this.m_admin.setDisplayMode(state, "widgets");
            } else if (column == 6) {
                this.m_admin.setDisplayMode(state, "properties");
            } else if (column == 4) {
                this.m_admin.setDisplayMode(state, "answerValues");
            } else if (column == 7) {
                Survey survey = this.m_survey.getSelectedSurvey(state);
                survey.delete();
                this.m_survey.clearSelection(state);
            }
        }

        public void headSelected(TableActionEvent e) {
        }
    }
}

