/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.ui.admin.DateRestrictForm;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public class OneQuestionPanel
extends SimpleContainer {
    private Label m_questionText;
    private DateRestrictForm m_dateForm;
    private AnswerTable m_answerTable;
    private StatisticsTable m_statisticsTable;
    private SingleSelectionModel m_label;
    private SurveySelectionModel m_survey;
    private RequestLocal m_persistentLabel = new RequestLocal(){

        public Object initialValue(PageState state) {
            PersistentLabel persistentLabel;
            BigDecimal labelID = new BigDecimal(OneQuestionPanel.this.m_label.getSelectedKey(state).toString());
            try {
                persistentLabel = new PersistentLabel(labelID);
            }
            catch (DataObjectNotFoundException e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
            return persistentLabel;
        }
    };
    private RequestLocal m_widgetClass = new RequestLocal(){

        public Object initialValue(PageState state) {
            BigDecimal labelID = new BigDecimal(OneQuestionPanel.this.m_label.getSelectedKey(state).toString());
            String queryName = "com.arsdigita.simplesurvey.GetWidgetClassAfterLabel";
            DataQuery dataQuery = SessionManager.getSession().retrieveQuery(queryName);
            dataQuery.setParameter("labelID", (Object)labelID);
            dataQuery.next();
            String widgetClass = (String)dataQuery.get("widgetClass");
            return widgetClass;
        }
    };

    public OneQuestionPanel(SurveySelectionModel survey, SingleSelectionModel label) {
        this.m_survey = survey;
        this.m_label = label;
        ActionLink m_complete = new ActionLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.back_to_question_list").localize());
        m_complete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OneQuestionPanel.this.m_label.clearSelection(e.getPageState());
            }
        });
        this.add((Component)m_complete);
        this.m_questionText = new Label("");
        this.m_questionText.setFontWeight("b");
        this.add((Component)this.m_questionText);
        this.m_dateForm = new DateRestrictForm("Show Answers");
        this.add((Component)this.m_dateForm);
        this.m_answerTable = new AnswerTable(this.m_survey, this.m_label, this.m_dateForm);
        this.add((Component)this.m_answerTable);
        this.m_statisticsTable = new StatisticsTable(this.m_label);
        this.add((Component)this.m_statisticsTable);
    }

    public void generateXML(PageState state, Element parent) {
        PersistentLabel label = this.getPersistentLabel(state);
        this.m_questionText.setLabel((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.question").localize() + label.getLabel(), state);
        this.setComponentVisibility(state);
        super.generateXML(state, parent);
    }

    private void setComponentVisibility(PageState state) {
        if (!this.isSingleAnswerQuestion(state)) {
            this.m_dateForm.setVisible(state, true);
            this.m_answerTable.setVisible(state, true);
            this.m_statisticsTable.setVisible(state, false);
        } else {
            this.m_dateForm.setVisible(state, false);
            this.m_answerTable.setVisible(state, false);
            this.m_statisticsTable.setVisible(state, true);
        }
    }

    public PersistentLabel getPersistentLabel(PageState state) {
        return (PersistentLabel)this.m_persistentLabel.get(state);
    }

    public String getPersistentWidgetClass(PageState state) {
        return (String)this.m_widgetClass.get(state);
    }

    public boolean isSingleAnswerQuestion(PageState state) {
        String widgetClass = this.getPersistentWidgetClass(state);
        return widgetClass.equals("com.arsdigita.formbuilder.PersistentRadioGroup");
    }

    private static TableModelBuilder getTableModelBuilder(final SingleSelectionModel label) {
        return new TableModelBuilder(){

            public TableModel makeModel(Table l, PageState state) {
                return new StatisticsTableModel(new BigDecimal(label.getSelectedKey(state).toString()));
            }

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }
        };
    }

    private static class StatisticsTableModel
    implements TableModel {
        private DataQuery m_statisticsQuery;
        private int m_totalNumberOfAnswers;

        public StatisticsTableModel(BigDecimal labelID) {
            String statQueryName = "com.arsdigita.simplesurvey.GetOneAnswerQuestionStatistics";
            this.m_statisticsQuery = SessionManager.getSession().retrieveQuery(statQueryName);
            this.m_statisticsQuery.setParameter("labelID", (Object)labelID);
            String numQueryName = "com.arsdigita.simplesurvey.GetTotalNumberOfAnswers";
            DataQuery numberQuery = SessionManager.getSession().retrieveQuery(numQueryName);
            numberQuery.setParameter("labelID", (Object)labelID);
            numberQuery.next();
            Integer totalNumberOfAnswers = new Integer(numberQuery.get("numberOfAnswers").toString());
            this.m_totalNumberOfAnswers = totalNumberOfAnswers;
            numberQuery.close();
        }

        public int getColumnCount() {
            return 3;
        }

        public boolean nextRow() {
            return this.m_statisticsQuery.next();
        }

        public Object getElementAt(int columnIndex) {
            String numberOfAnswers = this.m_statisticsQuery.get("numberOfAnswers").toString();
            Object returnValue = null;
            if (columnIndex == 0) {
                returnValue = this.m_statisticsQuery.get("value");
            } else if (columnIndex == 1) {
                returnValue = numberOfAnswers;
            } else if (columnIndex == 2) {
                returnValue = this.getPercentageOfAnswers(numberOfAnswers);
            }
            return returnValue;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_statisticsQuery.get("value");
        }

        private String getPercentageOfAnswers(String numberOfAnswers) {
            Integer numberOfAnswersInt = new Integer(numberOfAnswers);
            double ratio = 1.0;
            if (this.m_totalNumberOfAnswers != 0) {
                ratio = (double)numberOfAnswersInt.intValue() / (double)this.m_totalNumberOfAnswers;
            }
            double promille = ratio * 1000.0;
            long promilleRounded = Math.round(promille);
            double percentage = (double)promilleRounded / 10.0;
            return Double.toString(percentage);
        }
    }

    private class StatisticsTable
    extends Table {
        public StatisticsTable(SingleSelectionModel label) {
            super(OneQuestionPanel.getTableModelBuilder(label), (Object[])new String[]{"Answer Alternative", "Number of Answers", "Percentage of Total"});
        }
    }

    private static class AnswerQueryBuilder
    extends LockableImpl
    implements DataQueryBuilder {
        SingleSelectionModel m_label;
        DateRestrictForm m_dateForm;

        public AnswerQueryBuilder(SurveySelectionModel survey, SingleSelectionModel label, DateRestrictForm dateForm) {
            this.m_label = label;
            this.m_dateForm = dateForm;
        }

        public DataQuery makeDataQuery(DataTable t, PageState state) {
            String queryName = "com.arsdigita.simplesurvey.GetAnswersToQuestion";
            DataQuery dataQuery = SessionManager.getSession().retrieveQuery(queryName);
            dataQuery.setParameter("labelID", (Object)new BigDecimal(this.m_label.getSelectedKey(state).toString()));
            AnswerTable table = (AnswerTable)t;
            dataQuery.setParameter("startDate", (Object)this.m_dateForm.getStartDate(state));
            dataQuery.setParameter("endDate", (Object)this.m_dateForm.getEndDate(state));
            return dataQuery;
        }

        public String getKeyColumn() {
            return "answerID";
        }
    }

    private class AnswerTable
    extends DataTable {
        public AnswerTable(SurveySelectionModel survey, SingleSelectionModel label, DateRestrictForm dateForm) {
            super((DataQueryBuilder)new AnswerQueryBuilder(survey, label, dateForm));
            this.addColumn("Answer", "answerValue", true);
        }
    }
}

