/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.ui.admin.ReportPanel;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class OneResponsePanel
extends SimpleContainer {
    private SingleSelectionModel m_response;
    private SurveySelectionModel m_survey;
    private ResponseTable m_responseTable;

    public OneResponsePanel(SurveySelectionModel survey, SingleSelectionModel response) {
        this.m_survey = survey;
        this.m_response = response;
        ActionLink m_complete = new ActionLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.back_to_response_list").localize());
        m_complete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OneResponsePanel.this.m_response.clearSelection(e.getPageState());
            }
        });
        this.add((Component)m_complete);
        this.m_responseTable = new ResponseTable(this.m_response);
        this.add((Component)this.m_responseTable);
    }

    private class QuestionTableCellRenderer
    implements TableCellRenderer {
        private QuestionTableCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            return new Label(ReportPanel.getLabelAttribute((String)value));
        }
    }

    private static class ResponseQueryBuilder
    extends LockableImpl
    implements DataQueryBuilder {
        private SingleSelectionModel m_response;

        public ResponseQueryBuilder(SingleSelectionModel response) {
            this.m_response = response;
        }

        public DataQuery makeDataQuery(DataTable t, PageState s) {
            String queryName = "com.arsdigita.simplesurvey.GetAnswersForResponse";
            DataQuery dataQuery = SessionManager.getSession().retrieveQuery(queryName);
            BigDecimal responseID = new BigDecimal(this.m_response.getSelectedKey(s).toString());
            dataQuery.setParameter("responseID", (Object)responseID);
            return dataQuery;
        }

        public String getKeyColumn() {
            return "answerID";
        }
    }

    private class ResponseTable
    extends DataTable {
        public ResponseTable(SingleSelectionModel response) {
            super((DataQueryBuilder)new ResponseQueryBuilder(response));
            this.addColumn("Question", "attributeString", true, new QuestionTableCellRenderer());
            this.addColumn("Answer", "answerValue", false);
        }
    }
}

