/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotWhiteSpaceValidationListener;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.simplesurvey.Poll;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class PropertiesForm
extends Form {
    private SurveySelectionModel m_survey;
    private Class m_type;
    private TextField m_surveyName;
    private TextArea m_description;
    private com.arsdigita.bebop.form.Date m_startDate;
    private com.arsdigita.bebop.form.Date m_endDate;
    private RadioGroup m_responsesPublic;
    private RadioGroup m_quizType;

    public PropertiesForm(SurveySelectionModel survey, Class type) {
        super("properties" + type.getName());
        this.m_survey = survey;
        this.m_type = type;
        this.m_surveyName = new TextField("surveyName");
        this.m_surveyName.addValidationListener((ParameterListener)new NotWhiteSpaceValidationListener());
        this.m_description = new TextArea("description");
        this.m_startDate = new com.arsdigita.bebop.form.Date("startDate");
        this.m_endDate = new com.arsdigita.bebop.form.Date("endDate");
        this.add((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.name")));
        this.add((Component)this.m_surveyName);
        this.add((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.description")));
        this.m_description.setRows(20);
        this.m_description.setCols(60);
        this.add((Component)this.m_description);
        this.add((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.start_date")));
        this.add((Component)this.m_startDate);
        this.add((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.end_date")));
        this.add((Component)this.m_endDate);
        this.add((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.should_quiz_responses_be_public")));
        this.m_responsesPublic = new RadioGroup("responsesPublic");
        Option o1 = new Option("true", (Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.Yes")));
        Option o2 = new Option("false", (Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.No")));
        this.m_responsesPublic.addOption(o1);
        this.m_responsesPublic.addOption(o2);
        this.add((Component)this.m_responsesPublic);
        this.add((Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.what_type_of_quiz_is_this")));
        this.m_quizType = new RadioGroup("quizType");
        Option o3 = new Option("knowledge_test", (Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.knowledge_test_quiz")));
        Option o4 = new Option("personal_assessment", (Component)new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.personal_assessment_quiz")));
        this.m_quizType.addOption(o3);
        this.m_quizType.addOption(o4);
        this.add((Component)this.m_quizType);
        this.add((Component)new Submit("submit"), 2);
        this.addInitListener(new SurveyInitListener());
        this.addProcessListener(new PropertiesFormProcessListener());
    }

    private class PropertiesFormProcessListener
    implements FormProcessListener {
        private PropertiesFormProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PersistentForm form;
            Survey survey;
            PageState state = e.getPageState();
            if (PropertiesForm.this.m_survey.isSelected(state)) {
                survey = PropertiesForm.this.m_survey.getSelectedSurvey(state);
                form = survey.getForm();
            } else {
                survey = PropertiesForm.this.m_type.equals(Survey.class) ? new Survey() : new Poll();
                form = new PersistentForm();
                survey.setForm(form);
            }
            form.setAdminName((String)PropertiesForm.this.m_surveyName.getValue(state));
            form.setHTMLName(this.getHTMLName((String)PropertiesForm.this.m_surveyName.getValue(state)));
            form.setDescription((String)PropertiesForm.this.m_description.getValue(state));
            form.save();
            survey.setStartDate((Date)PropertiesForm.this.m_startDate.getValue(state));
            survey.setEndDate((Date)PropertiesForm.this.m_endDate.getValue(state));
            survey.setResponsesPublic(new Boolean((String)PropertiesForm.this.m_responsesPublic.getValue(state)));
            survey.setQuizType((String)PropertiesForm.this.m_quizType.getValue(state));
            survey.save();
        }

        private String getHTMLName(String surveyName) {
            String htmlName = surveyName.trim().toLowerCase();
            htmlName = htmlName.replace(' ', '_');
            return htmlName;
        }
    }

    private class SurveyInitListener
    implements FormInitListener {
        private SurveyInitListener() {
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (PropertiesForm.this.m_survey.isSelected(state)) {
                Survey survey = PropertiesForm.this.m_survey.getSelectedSurvey(state);
                PersistentForm form = survey.getForm();
                PropertiesForm.this.m_surveyName.setValue(state, (Object)form.getAdminName());
                PropertiesForm.this.m_description.setValue(state, (Object)form.getDescription());
                PropertiesForm.this.m_startDate.setValue(state, (Object)survey.getStartDate());
                PropertiesForm.this.m_endDate.setValue(state, (Object)survey.getEndDate());
                PropertiesForm.this.m_quizType.setValue(state, (Object)survey.getQuizType());
                if (survey.responsesArePublic()) {
                    PropertiesForm.this.m_responsesPublic.setValue(state, (Object)"true");
                } else {
                    PropertiesForm.this.m_responsesPublic.setValue(state, (Object)"false");
                }
            } else {
                PropertiesForm.this.m_surveyName.setValue(state, (Object)"");
                PropertiesForm.this.m_description.setValue(state, (Object)"");
                GregorianCalendar startCalendar = new GregorianCalendar();
                ((Calendar)startCalendar).add(5, 0);
                Date startDate = startCalendar.getTime();
                GregorianCalendar endCalendar = new GregorianCalendar();
                ((Calendar)endCalendar).add(5, 15);
                Date endDate = endCalendar.getTime();
                PropertiesForm.this.m_startDate.setValue(state, (Object)startDate);
                PropertiesForm.this.m_endDate.setValue(state, (Object)endDate);
                PropertiesForm.this.m_responsesPublic.setValue(state, (Object)"true");
                PropertiesForm.this.m_quizType.setValue(state, (Object)"knowledge_test");
            }
        }
    }
}

