/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.simplesurvey.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.util.Attributes;
import com.arsdigita.formbuilder.util.AttributeHelper;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.simplesurvey.Response;
import com.arsdigita.simplesurvey.ResponseCollection;
import com.arsdigita.simplesurvey.Survey;
import com.arsdigita.simplesurvey.ui.SurveySelectionModel;
import com.arsdigita.simplesurvey.ui.admin.DateRestrictForm;
import com.arsdigita.simplesurvey.ui.admin.OneQuestionPanel;
import com.arsdigita.simplesurvey.ui.admin.OneResponsePanel;
import com.arsdigita.simplesurvey.util.GlobalizationUtil;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.TooManyListenersException;

public class ReportPanel
extends SimpleContainer {
    private SurveySelectionModel m_survey;
    private ActionLink m_complete;
    private SegmentedPanel m_segmentedPanel;
    private QuestionList m_questionList;
    private ResponseList m_responseList;
    private DateRestrictForm m_dateForm;
    private OneResponsePanel m_response;
    private OneQuestionPanel m_question;

    public ReportPanel(SurveySelectionModel survey) {
        this.m_survey = survey;
        this.m_complete = new ActionLink((String)GlobalizationUtil.globalize("simplesurvey.ui.admin.back_to_survey_list").localize());
        this.m_complete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportPanel.this.fireCompletionEvent(e.getPageState());
            }
        });
        this.add((Component)this.m_complete);
        this.m_segmentedPanel = new SegmentedPanel();
        Label questionLabel = new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.questions_of_the_survey"));
        this.m_questionList = new QuestionList(this.m_survey);
        this.m_segmentedPanel.addSegment((Component)questionLabel, (Component)this.m_questionList);
        Label responseLabel = new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.responses_to_the_survey"));
        this.m_dateForm = new DateRestrictForm("Show responses");
        this.m_responseList = new ResponseList(this.m_survey, this.m_dateForm);
        SegmentedPanel.Segment responseSegment = this.m_segmentedPanel.addSegment((Component)responseLabel, (Component)this.m_dateForm);
        responseSegment.add((Component)this.m_responseList);
        Label exportLabel = new Label(GlobalizationUtil.globalize("simplesurvey.ui.admin.export_response_data"));
        Link exportLink = new Link("Export to CSV file", "export.jsp");
        try {
            exportLink.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent event) {
                    PageState state = event.getPageState();
                    Link link = (Link)event.getTarget();
                    link.setVar("survey", ReportPanel.this.m_survey.getSelectedKey(state).toString());
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        this.m_segmentedPanel.addSegment((Component)exportLabel, (Component)exportLink);
        this.m_response = new OneResponsePanel(this.m_survey, this.m_responseList.getSelectionModel());
        this.m_question = new OneQuestionPanel(this.m_survey, this.m_questionList.getSelectionModel());
        this.m_responseList.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState state = e.getPageState();
                if (ReportPanel.this.m_responseList.getSelectionModel().isSelected(state)) {
                    ReportPanel.this.m_segmentedPanel.setVisible(state, false);
                    ReportPanel.this.m_complete.setVisible(state, false);
                    ReportPanel.this.m_question.setVisible(state, false);
                    ReportPanel.this.m_response.setVisible(state, true);
                } else {
                    ReportPanel.this.m_complete.setVisible(state, true);
                    ReportPanel.this.m_segmentedPanel.setVisible(state, true);
                    ReportPanel.this.m_question.setVisible(state, false);
                    ReportPanel.this.m_response.setVisible(state, false);
                }
            }
        });
        this.m_questionList.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState state = e.getPageState();
                if (ReportPanel.this.m_questionList.getSelectionModel().isSelected(state)) {
                    ReportPanel.this.m_segmentedPanel.setVisible(state, false);
                    ReportPanel.this.m_complete.setVisible(state, false);
                    ReportPanel.this.m_question.setVisible(state, true);
                    ReportPanel.this.m_response.setVisible(state, false);
                } else {
                    ReportPanel.this.m_complete.setVisible(state, true);
                    ReportPanel.this.m_segmentedPanel.setVisible(state, true);
                    ReportPanel.this.m_question.setVisible(state, false);
                    ReportPanel.this.m_response.setVisible(state, false);
                }
            }
        });
        this.add((Component)this.m_segmentedPanel);
        this.add((Component)this.m_response);
        this.add((Component)this.m_question);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_response, false);
        p.setVisibleDefault((Component)this.m_question, false);
    }

    public static String getLabelAttribute(String attributeString) {
        AttributeHelper attributeHelper = new AttributeHelper();
        Attributes attributes = attributeHelper.getAttributesMap(attributeString);
        String labelText = attributes.getAttribute("label");
        return labelText;
    }

    private class QuestionListCellRenderer
    implements ListCellRenderer {
        private QuestionListCellRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            return new ControlLink(ReportPanel.getLabelAttribute((String)value));
        }
    }

    private static class QuestionListModel
    implements ListModel {
        private DataQuery m_labels;

        public QuestionListModel(DataQuery labels) {
            this.m_labels = labels;
        }

        public boolean next() {
            return this.m_labels.next();
        }

        public Object getElement() {
            return this.m_labels.get("attributeString");
        }

        public String getKey() {
            return this.m_labels.get("labelID").toString();
        }
    }

    private static class QuestionListModelBuilder
    implements ListModelBuilder {
        private SurveySelectionModel m_survey;

        public QuestionListModelBuilder(SurveySelectionModel survey) {
            this.m_survey = survey;
        }

        public ListModel makeModel(List l, PageState state) {
            Survey survey = this.m_survey.getSelectedSurvey(state);
            return new QuestionListModel(survey.getLabelDataQuery());
        }

        public void lock() {
        }

        public boolean isLocked() {
            return true;
        }
    }

    private class QuestionList
    extends List {
        public QuestionList(SurveySelectionModel survey) {
            super((ListModelBuilder)new QuestionListModelBuilder(survey));
            this.setCellRenderer(new QuestionListCellRenderer());
        }
    }

    private class ResponseListCellRenderer
    implements ListCellRenderer {
        private ResponseListCellRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            return new ControlLink(value.toString());
        }
    }

    private static class ResponseListModel
    implements ListModel {
        private ResponseCollection m_responses;
        private Response m_response;

        public ResponseListModel(ResponseCollection responses) {
            this.m_responses = responses;
        }

        public boolean next() {
            if (this.m_responses.next()) {
                this.m_response = this.m_responses.getResponse();
                return true;
            }
            this.m_response = null;
            return false;
        }

        public Object getElement() {
            return this.m_response.getEntryDate();
        }

        public String getKey() {
            return this.m_response.getID().toString();
        }
    }

    private static class ResponseListModelBuilder
    implements ListModelBuilder {
        private SurveySelectionModel m_survey;
        private DateRestrictForm m_dateForm;

        public ResponseListModelBuilder(SurveySelectionModel survey, DateRestrictForm dateForm) {
            this.m_survey = survey;
            this.m_dateForm = dateForm;
        }

        public ListModel makeModel(List l, PageState state) {
            Survey survey = this.m_survey.getSelectedSurvey(state);
            ResponseCollection responses = survey.getResponses();
            Filter startFilter = responses.addFilter("entryDate > :startDate");
            startFilter.set("startDate", (Object)this.m_dateForm.getStartDate(state));
            Filter endFilter = responses.addFilter("entryDate < :endDate");
            endFilter.set("endDate", (Object)this.m_dateForm.getEndDate(state));
            return new ResponseListModel(responses);
        }

        public void lock() {
        }

        public boolean isLocked() {
            return true;
        }
    }

    private class ResponseList
    extends List {
        public ResponseList(SurveySelectionModel survey, DateRestrictForm dateForm) {
            super((ListModelBuilder)new ResponseListModelBuilder(survey, dateForm));
            this.setCellRenderer(new ResponseListCellRenderer());
        }
    }
}

