/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.userprefs;

import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.User;
import com.arsdigita.london.userprefs.Pref;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersistentUserPrefs
extends DomainObject {
    private static final Logger s_log = Logger.getLogger(PersistentUserPrefs.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.london.userprefs.PersistentUserPrefs";
    public static final String ID = "id";
    public static final String USER = "user";
    public static final String PREFS = "prefs";
    public static final String COOKIE = "cookie";

    PersistentUserPrefs() {
        super(BASE_DATA_OBJECT_TYPE);
        try {
            this.set(ID, Sequences.getNextValue());
        }
        catch (SQLException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
    }

    public PersistentUserPrefs(OID oid) {
        super(oid);
    }

    public PersistentUserPrefs(DataObject obj) {
        super(obj);
    }

    static void domainInit() {
        DomainObjectFactory.registerInstantiator((String)BASE_DATA_OBJECT_TYPE, (DomainObjectInstantiator)new DomainObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject obj) {
                return new PersistentUserPrefs(obj);
            }
        });
    }

    static PersistentUserPrefs retrieveForUser(User user) {
        DataCollection pups = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        pups.addEqualsFilter("user.id", (Object)user.getID());
        PersistentUserPrefs prefs = null;
        if (pups.next()) {
            prefs = new PersistentUserPrefs(pups.getDataObject());
            if (pups.next()) {
                s_log.warn((Object)("User " + user.getOID() + " has multiple user " + "preferences"));
            }
        }
        pups.close();
        return prefs;
    }

    static PersistentUserPrefs retrieveForCookie(Long cookie) {
        DataCollection pups = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        pups.addEqualsFilter(COOKIE, (Object)cookie);
        PersistentUserPrefs prefs = null;
        if (pups.next()) {
            prefs = new PersistentUserPrefs(pups.getDataObject());
            if (pups.next()) {
                s_log.warn((Object)("Cookie " + cookie + " has multiple user " + "preferences"));
            }
        }
        pups.close();
        return prefs;
    }

    public String getValue(String key) {
        DomainCollection prefs = this.getAllValues();
        prefs.addEqualsFilter("key", (Object)key);
        String value = null;
        if (prefs.next()) {
            value = (String)prefs.get("value");
            if (prefs.next()) {
                s_log.warn((Object)("Users prefs " + this.getOID() + " has multiple " + "values for " + key));
            }
        }
        prefs.close();
        return value;
    }

    public DomainCollection getAllValues() {
        DataAssociation prefs = (DataAssociation)this.get(PREFS);
        return new DomainCollection((DataCollection)prefs.getDataAssociationCursor());
    }

    public void removeValue(String key) {
        DomainCollection prefs = this.getAllValues();
        prefs.addEqualsFilter("key", (Object)key);
        while (prefs.next()) {
            prefs.getDomainObject().delete();
        }
    }

    public void setValue(String key, String value) {
        Pref pref;
        DomainCollection prefs = this.getAllValues();
        prefs.addEqualsFilter("key", (Object)key);
        if (prefs.next()) {
            pref = (Pref)prefs.getDomainObject();
            if (prefs.next()) {
                s_log.warn((Object)("Users prefs " + this.getOID() + " has multiple " + "values for " + key));
            }
        } else {
            pref = new Pref();
            pref.setKey(key);
        }
        prefs.close();
        pref.setValue(value);
        if (pref.isNew()) {
            this.add(PREFS, pref);
        }
    }

    public void setAllValues(Map newPrefs) {
        if (newPrefs.isEmpty()) {
            s_log.debug((Object)"All values removed. Deleting prefs object.");
            this.delete();
            return;
        }
        s_log.debug((Object)"Setting all values");
        HashSet newKeys = new HashSet(newPrefs.keySet());
        DomainCollection prefs = this.getAllValues();
        while (prefs.next()) {
            String key = (String)prefs.get("key");
            String value = (String)prefs.get("value");
            if (!newKeys.contains(key)) {
                prefs.getDomainObject().delete();
                continue;
            }
            String newValue = (String)newPrefs.get(key);
            if (!value.equals(newValue)) {
                Pref pref = (Pref)prefs.getDomainObject();
                pref.setValue(newValue);
            }
            newKeys.remove(key);
        }
        for (String key : newKeys) {
            Pref pref = new Pref();
            pref.setKey(key);
            pref.setValue((String)newPrefs.get(key));
            this.add(PREFS, pref);
        }
    }

    void setUser(User user) {
        this.setAssociation(USER, (DomainObject)user);
    }

    User getUser() {
        return (User)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(USER)));
    }

    void setCookie(Long cookie) {
        this.set(COOKIE, cookie);
    }

    Long getCookie() {
        return (Long)this.get(COOKIE);
    }
}

