/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.userprefs;

import com.arsdigita.caching.CacheTable;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.User;
import com.arsdigita.london.userprefs.PersistentUserPrefs;
import com.arsdigita.london.userprefs.Pref;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class UserPrefs {
    private static final Logger s_log = Logger.getLogger(UserPrefs.class);
    private static final String COOKIE = "WAF_USER_PREFS";
    static final String SESSION_ATTRIBUTE = UserPrefs.class.getName();
    private OID m_user = null;
    private OID m_persistentPrefs = null;
    private Long m_cookie = null;
    private HashMap m_prefs = new HashMap();
    private static final CacheTable s_prefsCache = new CacheTable("user_preferences");

    private UserPrefs() {
    }

    private UserPrefs(PersistentUserPrefs persistentPrefs) {
        this.init(persistentPrefs);
    }

    private void init(PersistentUserPrefs persistentPrefs) {
        this.m_persistentPrefs = persistentPrefs.getOID();
        this.m_cookie = persistentPrefs.getCookie();
        this.m_user = persistentPrefs.getUser() == null ? null : persistentPrefs.getUser().getOID();
        DomainCollection prefs = persistentPrefs.getAllValues();
        while (prefs.next()) {
            Pref pref = (Pref)prefs.getDomainObject();
            this.m_prefs.put(pref.getKey(), pref.getValue());
        }
    }

    public static UserPrefs retrieve(HttpServletRequest req, HttpServletResponse res) {
        HttpSession session = req.getSession();
        UserPrefs prefs = (UserPrefs)s_prefsCache.get(session.getId());
        if (null != prefs) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Retrieved user prefs for session " + session.getId()));
            }
            return prefs;
        }
        PersistentUserPrefs persistentPrefs = UserPrefs.retrievePersistent(req, res);
        if (null != persistentPrefs) {
            prefs = new UserPrefs(persistentPrefs);
        } else {
            prefs = new UserPrefs();
            User user = (User)Kernel.getContext().getParty();
            if (null != user) {
                prefs.m_user = user.getOID();
            } else {
                Long cookie;
                try {
                    SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                    cookie = new Long(random.nextLong());
                }
                catch (NoSuchAlgorithmException ex) {
                    s_log.warn((Object)"Unable to get SecureRandom for SHA1PRNG. Falling back to insecure random generator.");
                    cookie = new Long(new Random().nextLong());
                }
                prefs.m_cookie = cookie;
                UserPrefs.setCookie(res, cookie.toString());
            }
            s_log.debug((Object)"Created new prefs");
        }
        s_prefsCache.put(session.getId(), (Object)prefs);
        return prefs;
    }

    private static PersistentUserPrefs retrievePersistent(HttpServletRequest req, HttpServletResponse res) {
        PersistentUserPrefs persistentPrefs = null;
        User user = (User)Kernel.getContext().getParty();
        if (null != user) {
            persistentPrefs = PersistentUserPrefs.retrieveForUser(user);
        }
        if (null != persistentPrefs) {
            s_log.debug((Object)"Got prefs for user");
            return persistentPrefs;
        }
        Long cookie = UserPrefs.getCookie(req);
        if (null != cookie && null == (persistentPrefs = PersistentUserPrefs.retrieveForCookie(cookie))) {
            UserPrefs.removeCookie(res);
        }
        if (null != persistentPrefs) {
            s_log.debug((Object)"Got prefs for cookie");
            return persistentPrefs;
        }
        s_log.debug((Object)"No existing prefs");
        return null;
    }

    public String get(String key) {
        return (String)this.m_prefs.get(key);
    }

    public Iterator getAll() {
        return this.m_prefs.entrySet().iterator();
    }

    public void set(String key, String value, HttpServletRequest req, HttpServletResponse res) {
        this.m_prefs.put(key, value);
        PersistentUserPrefs prefs = this.getPersistent();
        if (null == prefs) {
            prefs = this.createPersistent(req, res);
        }
        prefs.setValue(key, value);
    }

    public void remove(String key, HttpServletRequest req) {
        this.m_prefs.remove(key);
        PersistentUserPrefs persistent = this.getPersistent();
        if (!this.m_prefs.isEmpty()) {
            if (null != persistent) {
                persistent.removeValue(key);
            }
        } else {
            if (null != persistent) {
                persistent.delete();
            }
            req.getSession().setAttribute(SESSION_ATTRIBUTE, null);
            this.m_persistentPrefs = null;
        }
    }

    public void persist(HttpServletRequest req, HttpServletResponse res) {
        s_log.info((Object)"Persisting session");
        PersistentUserPrefs prefs = this.getPersistent();
        if (null == prefs) {
            prefs = this.createPersistent(req, res);
        }
        prefs.setAllValues(this.m_prefs);
        prefs.save();
        s_log.debug((Object)"Session persisted");
    }

    private PersistentUserPrefs getPersistent() {
        User user;
        PersistentUserPrefs prefs = null;
        if (null != this.m_persistentPrefs) {
            try {
                prefs = new PersistentUserPrefs(this.m_persistentPrefs);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.warn((Object)"User preferences object contained bogus persistent preferences OID");
            }
        }
        if (null == this.m_user && null != (user = (User)Kernel.getContext().getParty())) {
            prefs.setUser(user);
            prefs.setCookie(null);
        }
        return prefs;
    }

    private PersistentUserPrefs createPersistent(HttpServletRequest req, HttpServletResponse res) {
        PersistentUserPrefs prefs = UserPrefs.retrievePersistent(req, res);
        if (null == prefs) {
            prefs = new PersistentUserPrefs();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Initializing new user preferences: " + prefs.getOID()));
            }
            if (null != this.m_user) {
                prefs.setUser(new User(this.m_user));
            } else if (null != this.m_cookie) {
                prefs.setCookie(this.m_cookie);
            } else {
                throw new UncheckedWrapperException("User preferences object doesn't contain either a user or a cookie object");
            }
            this.m_persistentPrefs = prefs.getOID();
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Reusing existing persistent preferences " + prefs.getOID()));
            }
            this.init(prefs);
        }
        return prefs;
    }

    private static Long getCookie(HttpServletRequest req) {
        Cookie[] cookieJar = req.getCookies();
        if (null == cookieJar) {
            return null;
        }
        for (int i = 0; i < cookieJar.length; ++i) {
            if (!COOKIE.equals(cookieJar[i].getName())) continue;
            try {
                return Long.valueOf(cookieJar[i].getValue());
            }
            catch (NumberFormatException ex) {
                s_log.warn((Object)("Bogus cookie value: " + cookieJar[i].getValue()));
            }
        }
        return null;
    }

    private static void setCookie(HttpServletResponse res, String value) {
        Cookie cookie = new Cookie(COOKIE, value);
        cookie.setMaxAge(Integer.MAX_VALUE);
        res.addCookie(cookie);
    }

    private static void removeCookie(HttpServletResponse res) {
        Cookie cookie = new Cookie(COOKIE, "");
        cookie.setMaxAge(0);
        res.addCookie(cookie);
    }
}

