/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.userprefs.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BooleanParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.london.userprefs.UserPrefs;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserPrefsComponent
extends SimpleComponent {
    private static final Logger s_log = Logger.getLogger(UserPrefsComponent.class);
    public static final String XMLNS = "http://xmlns.redhat.com/userprefs/1.0";
    private StringParameter m_setKey = new StringParameter("pref.set.key");
    private StringParameter m_setValue = new StringParameter("pref.set.value");
    private StringParameter m_remove = new StringParameter("pref.remove");
    private BooleanParameter m_immediate = new BooleanParameter("pref.immediate");

    public void generateXML(PageState ps, Element parent) {
        UserPrefs prefs = UserPrefs.retrieve(ps.getRequest(), ps.getResponse());
        Element rootE = parent.newChildElement("up:userPreferences", XMLNS);
        Iterator values = prefs.getAll();
        while (values.hasNext()) {
            Map.Entry pref = (Map.Entry)values.next();
            String key = (String)pref.getKey();
            String value = (String)pref.getValue();
            Element prefE = rootE.newChildElement("up:preference", XMLNS);
            prefE.addAttribute("key", key);
            if (null == value) continue;
            prefE.addAttribute("value", value);
        }
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_setKey);
        p.addGlobalStateParam((ParameterModel)this.m_setValue);
        p.addGlobalStateParam((ParameterModel)this.m_remove);
        p.addGlobalStateParam((ParameterModel)this.m_immediate);
        p.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent ev) {
                PageState ps = ev.getPageState();
                String setKey = (String)ps.getValue((ParameterModel)UserPrefsComponent.this.m_setKey);
                String setValue = (String)ps.getValue((ParameterModel)UserPrefsComponent.this.m_setValue);
                String remove = (String)ps.getValue((ParameterModel)UserPrefsComponent.this.m_remove);
                UserPrefs prefs = UserPrefs.retrieve(ps.getRequest(), ps.getResponse());
                boolean acted = false;
                if (null != setKey) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Set in " + ps.getRequest().getRequestURI() + '?' + ps.getRequest().getQueryString()));
                    }
                    prefs.set(setKey, setValue, ps.getRequest(), ps.getResponse());
                    acted = true;
                }
                if (null != remove) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Remove in " + ps.getRequest().getRequestURI() + '?' + ps.getRequest().getQueryString()));
                    }
                    prefs.remove(remove, ps.getRequest());
                    acted = true;
                }
                if (acted) {
                    ps.setValue((ParameterModel)UserPrefsComponent.this.m_setKey, null);
                    ps.setValue((ParameterModel)UserPrefsComponent.this.m_setValue, null);
                    ps.setValue((ParameterModel)UserPrefsComponent.this.m_remove, null);
                    try {
                        throw new RedirectSignal(ps.stateAsURL(), true);
                    }
                    catch (IOException ex) {
                        throw new UncheckedWrapperException((Throwable)ex);
                    }
                }
            }
        });
    }
}

