/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.exporter;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.london.exporter.ContentExporter;
import com.arsdigita.london.util.Transaction;
import com.arsdigita.util.cmd.Program;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import java.io.File;
import org.apache.commons.cli.CommandLine;

public class ItemExportTool
extends Program {
    public ItemExportTool() {
        super("Item Export Tool", "1.0.0", "ITEM-DIR ASSET-DIR CONTENT-SECTION");
    }

    public void doRun(CommandLine cmdLine) {
        File itemDir;
        String[] args = cmdLine.getArgs();
        if (args.length != 3) {
            this.help(System.err);
            System.exit(1);
        }
        if (!(itemDir = new File(args[0])).exists() && !itemDir.mkdirs()) {
            System.err.println("mkdirs " + itemDir + "failed");
            return;
        }
        File assetDir = new File(args[1]);
        if (!assetDir.exists() && !assetDir.mkdirs()) {
            System.err.println("mkdirs " + assetDir + "failed");
            return;
        }
        final ContentExporter exporter = new ContentExporter(itemDir, assetDir);
        final StringBuilder path = new StringBuilder();
        if (!args[2].startsWith("/")) {
            path.append("/");
        }
        path.append(args[2]);
        if (!args[2].endsWith("/")) {
            path.append("/");
        }
        Transaction txn = new Transaction(){

            public void doRun() {
                ContentSection section = (ContentSection)Application.retrieveApplicationForPath((String)path.toString());
                if (section == null) {
                    throw new DataObjectNotFoundException("No content section has a path of '" + path + "'");
                }
                exporter.exportManifest(section, "draft", Web.getConfig().getHost().toString());
            }
        };
        txn.run();
        exporter.exportItems();
    }

    public static void main(String[] args) {
        new ItemExportTool().run(args);
    }
}

