/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.pdf;

import com.arsdigita.formbuilder.pdf.PDFConfig;
import com.arsdigita.formbuilder.pdf.PDFListener;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.Driver;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Converter
extends HttpServlet {
    private static final Logger s_log = Logger.getLogger(Converter.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.pdf.Converter";
    private TransformerFactory transformerFactory;

    public void init() throws ServletException {
        this.transformerFactory = TransformerFactory.newInstance();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Document xmldoc;
        Vector objOuterFormData;
        s_log.debug((Object)"Converter-doGet(HttpServletRequest,HttpServletResponse)-Enter");
        HttpSession session = req.getSession();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Using session: " + session.getId()));
        }
        if (null == (objOuterFormData = PDFListener.getFormData(session.getId()))) {
            s_log.error((Object)"Converter called with no FormData in session");
            return;
        }
        Iterator iter = objOuterFormData.iterator();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Dumping FormData");
            while (iter.hasNext()) {
                Vector inner = (Vector)iter.next();
                s_log.debug((Object)(inner.firstElement().toString() + ": " + inner.lastElement().toString()));
            }
            iter = objOuterFormData.iterator();
        }
        Vector objInnerFormData = null;
        byte[] bytes = "<?xml version='1.0' encoding='UTF-8'?><Document/>".getBytes();
        ByteArrayInputStream objByteArrayInputStream = new ByteArrayInputStream(bytes);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            xmldoc = db.parse(objByteArrayInputStream);
        }
        catch (Exception ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
        Element grpRoot = xmldoc.getDocumentElement();
        while (iter.hasNext()) {
            objInnerFormData = new Vector();
            objInnerFormData = (Vector)iter.next();
            String strkey = (String)objInnerFormData.firstElement();
            String strValue = (String)objInnerFormData.lastElement();
            Element root = xmldoc.createElement("Section");
            Element captionNode = xmldoc.createElement("Caption");
            Text captionText = xmldoc.createTextNode(strkey);
            captionNode.appendChild(captionText);
            Element valueNode = xmldoc.createElement("Value");
            Text valueText = xmldoc.createTextNode(strValue);
            valueNode.appendChild(valueText);
            root.appendChild(captionNode);
            root.appendChild(valueNode);
            grpRoot.appendChild(root);
        }
        res.setContentType("application/pdf");
        Driver driver = new Driver();
        driver.setRenderer(1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        driver.setOutputStream((OutputStream)out);
        StreamSource xsltSrc = new StreamSource(new File(PDFConfig.retrieve().getXSLFile()));
        try {
            Transformer transformer = this.transformerFactory.newTransformer(xsltSrc);
            SAXResult result = new SAXResult(driver.getContentHandler());
            transformer.transform(new DOMSource(xmldoc), result);
        }
        catch (Exception ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
        res.setContentLength(out.size());
        res.getOutputStream().write(out.toByteArray());
        res.getOutputStream().flush();
        s_log.debug((Object)"Converter-doGet(HttpServletRequest,HttpServletResponse)-Exit");
    }
}

