/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.pdf;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.caching.CacheTable;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.CompoundComponent;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.WidgetLabel;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class PDFListener
extends PersistentProcessListener {
    private static final Logger s_log = Logger.getLogger(PDFListener.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.formbuilder.pdf.PDFListener";
    private static final CacheTable s_dataCache = new CacheTable("pdf_formdata");

    public PDFListener() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public PDFListener(String typeName) {
        super(typeName);
    }

    public PDFListener(DataObject obj) {
        super(obj);
    }

    public PDFListener(OID oid) {
        super(oid);
    }

    public PDFListener(BigDecimal id) {
        super(id);
    }

    public static PDFListener create(String name, String description, String cName) {
        PDFListener objPDFListener = new PDFListener();
        objPDFListener.setup(name, description);
        return objPDFListener;
    }

    protected void setup(String name, String description) {
        super.setup(name, description);
    }

    public boolean isContainerModified() {
        return false;
    }

    public FormProcessListener createProcessListener() {
        return new PDFProcessListener();
    }

    static Vector getFormData(String sessionId) {
        return (Vector)s_dataCache.get(sessionId);
    }

    private class PDFProcessListener
    implements FormProcessListener {
        public void process(FormSectionEvent objFormSectionEvent) throws FormProcessException {
            s_log.debug((Object)"PDFListener-process(FormSectionEvent)-Enter");
            FormData data = objFormSectionEvent.getFormData();
            HttpServletRequest req = objFormSectionEvent.getPageState().getRequest();
            HttpSession session = req.getSession(true);
            Vector objOuterFormData = new Vector();
            DataAssociationCursor components = PDFListener.this.getForm().getComponents();
            while (components.next()) {
                PersistentComponent c = (PersistentComponent)DomainObjectFactory.newInstance((DataObject)components.getDataObject());
                this.handleComponent(data, c, objOuterFormData);
            }
            s_dataCache.put(session.getId(), objOuterFormData);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Saving with key: " + session.getId()));
                for (Vector entry : objOuterFormData) {
                    s_log.debug((Object)(entry.firstElement().toString() + ": " + entry.lastElement().toString()));
                }
            }
            String strURL = req.getScheme() + "://" + Web.getConfig().getServer() + "/ccm-formbuilder-pdf/Converter/";
            s_log.debug((Object)"PDFListener-process(FormSectionEvent)-Redirecting");
            throw new RedirectSignal(strURL, true);
        }

        private void handleComponent(FormData data, PersistentComponent c, Vector output) {
            if (c instanceof PersistentWidget) {
                PersistentWidget w = (PersistentWidget)c;
                Vector<String> entry = new Vector<String>();
                WidgetLabel label = WidgetLabel.findByWidget((PersistentWidget)w);
                if (null == label) {
                    entry.add(w.getParameterName());
                } else {
                    entry.add(label.getLabel());
                }
                Object value = w.getValue(data);
                if (null != value && value.getClass().isArray()) {
                    Object[] values = (Object[])value;
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < values.length; ++i) {
                        buf.append(values[i].toString());
                        if (values.length - 1 == i) continue;
                        buf.append(' ');
                    }
                    value = buf;
                }
                if (null == value) {
                    entry.add("");
                } else {
                    entry.add(value.toString());
                }
                output.add(entry);
            } else if (c instanceof CompoundComponent) {
                Iterator i = ((CompoundComponent)c).getComponentsIter();
                while (i.hasNext()) {
                    this.handleComponent(data, (PersistentComponent)i.next(), output);
                }
            } else if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Ignoring component: " + c.getClass().getName()));
            }
        }
    }
}

