/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bookmarks;

import com.arsdigita.bookmarks.BookmarkCollection;
import com.arsdigita.bookmarks.Bookmarks;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;

public class Bookmark
extends ACSObject {
    private static final int SORT_KEY_JUMP = 10;
    private Bookmarks m_bmrkapp = null;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workspace.Bookmark";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Bookmark(DataObject dataObject) {
        super(dataObject);
    }

    public Bookmark(String name, String URLstring) {
        super(BASE_DATA_OBJECT_TYPE);
        this.setName(name);
        this.setURL(URLstring);
        this.setCreateDate();
        this.setSortKey(50);
        this.setAuthor();
        this.setVisits(0);
    }

    public static Bookmark retrieveBookmark(BigDecimal bmrkID) {
        Assert.exists((Object)bmrkID);
        return Bookmark.retrieveBookmark(new OID(BASE_DATA_OBJECT_TYPE, (Object)bmrkID));
    }

    public static Bookmark retrieveBookmark(DataObject dataObject) {
        Assert.exists((Object)dataObject);
        return new Bookmark(dataObject);
    }

    public static Bookmark retrieveBookmark(OID oid) {
        Assert.exists((Object)oid);
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        return Bookmark.retrieveBookmark(dataObject);
    }

    public Bookmarks getBookmarkApplication() {
        DataObject bmrkdata;
        if (this.m_bmrkapp == null && (bmrkdata = (DataObject)this.get("bookmarkapp")) != null) {
            this.m_bmrkapp = new Bookmarks(bmrkdata);
        }
        return this.m_bmrkapp;
    }

    public void setBookmarkApplication(Bookmarks bmrkapp) {
        this.m_bmrkapp = bmrkapp;
        this.setAssociation("bookmarkapp", (DomainObject)bmrkapp);
    }

    public static BookmarkCollection retrieveAllBookmarks() {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        BookmarkCollection bmrkCollection = new BookmarkCollection(dataCollection);
        return bmrkCollection;
    }

    public String getName() {
        String name = (String)this.get("bookmark_name");
        Assert.exists((Object)name);
        return name;
    }

    public String getURL() {
        String url = (String)this.get("bookmark_url");
        Assert.exists((Object)url);
        return url;
    }

    public String getDescription() {
        String description = (String)this.get("bookmark_desc");
        Assert.exists((Object)description);
        return description;
    }

    public String getCreateDate() {
        String creation = (String)this.get("create_date");
        return creation;
    }

    public String getModDate() {
        String mod = (String)this.get("mod_date");
        if (mod == null) {
            mod = (String)this.get("create_date");
        }
        return mod;
    }

    public boolean getNewWindow() {
        return "1".equals(this.get("new_window"));
    }

    public String getAuthor() {
        String author = (String)this.get("author");
        return author;
    }

    private int getVisits() {
        int v = (Integer)this.get("visits");
        return v;
    }

    public String getNumVisits() {
        Integer v = (Integer)this.get("visits");
        return v.toString();
    }

    public void setName(String name) {
        Assert.exists((Object)name);
        this.set("bookmark_name", name);
    }

    public void setURL(String url) {
        Assert.exists((Object)url);
        if (url.startsWith("http://")) {
            this.set("bookmark_url", url);
        } else if (url.startsWith("HTTP://")) {
            this.set("bookmark_url", url);
        } else if (url.startsWith("https://")) {
            this.set("bookmark_url", url);
        } else if (url.startsWith("HTTPS://")) {
            this.set("bookmark_url", url);
        } else {
            String newURL = "http://" + url;
            this.set("bookmark_url", newURL);
        }
    }

    public void setDescription(String desc) {
        this.set("bookmark_desc", desc);
    }

    private void setCreateDate() {
        Date currentDate = new Date();
        String date = DateFormat.getDateTimeInstance().format(currentDate);
        this.set("create_date", date);
    }

    public void setModDate() {
        Date currentDate = new Date();
        String date = DateFormat.getDateTimeInstance().format(currentDate);
        this.set("mod_date", date);
    }

    public void setNewWindow(boolean newWindow) {
        this.set("new_window", newWindow ? "1" : "0");
    }

    private void setAuthor() {
        Party party = Kernel.getContext().getParty();
        String name = party.getDisplayName();
        this.set("author", name);
    }

    private void setVisits(int visits) {
        this.set("visits", new Integer(visits));
    }

    public void visitsPlusPlus() {
        int visits = this.getVisits();
        this.setVisits(visits++);
    }

    public int getSortKey() {
        return (Integer)this.get("sortKey");
    }

    public void setSortKey(int sortKey) {
        this.set("sortKey", new Integer(sortKey));
    }

    protected void afterSave() {
        super.afterSave();
        PermissionService.setContext((ACSObject)this, (ACSObject)this.getBookmarkApplication());
    }
}

