/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bookmarks.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bookmarks.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.web.Application;
import com.arsdigita.xml.Element;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class BookmarkBasePage
extends Page {
    private final Container m_global;
    private final Container m_header;
    private final Container m_body;
    private final Container m_footer;
    private IntegerParameter m_selected = new IntegerParameter("m");
    public static final String BMRK_GLOBAL_ELEMENT = "bmrk:global";
    public static final String BMRK_HEADER_ELEMENT = "bmrk:header";
    public static final String BMRK_BODY_ELEMENT = "bmrk:body";
    public static final String BMRK_FOOTER_ELEMENT = "bmrk:footer";
    public static final String BMRK_XML_NS = "http://www.redhat.com/bmrk/1.0";
    private static final Logger s_log = Logger.getLogger(BookmarkBasePage.class);
    private String m_view;
    private Link m_viewLink;
    private boolean CHECK_PERMISSION = true;

    public BookmarkBasePage() {
        this(null);
    }

    public BookmarkBasePage(String view) {
        super(new Label(), (Container)new SimpleContainer());
        this.setClassAttr("bmrk");
        this.m_panel = new Panel();
        this.addGlobalStateParam((ParameterModel)this.m_selected);
        this.m_global = new SimpleContainer(BMRK_GLOBAL_ELEMENT, BMRK_XML_NS);
        this.m_header = new SimpleContainer(BMRK_HEADER_ELEMENT, BMRK_XML_NS);
        this.m_body = new SimpleContainer(BMRK_BODY_ELEMENT, BMRK_XML_NS);
        this.m_footer = new SimpleContainer(BMRK_FOOTER_ELEMENT, BMRK_XML_NS);
        super.add((Component)this.m_global);
        super.add((Component)this.m_header);
        super.add((Component)this.m_body);
        super.add((Component)this.m_footer);
        this.m_view = view;
    }

    public void lock() {
        this.buildPage();
        super.lock();
    }

    protected final void buildPage() {
        this.buildTitle();
        this.buildContextBar();
        this.buildGlobal(this.getGlobal());
        this.buildHeader(this.getHeader());
        this.buildBody(this.getBody());
        this.buildFooter(this.getFooter());
    }

    protected void buildTitle() {
        if (this.m_view != null && this.m_view.equals("admin")) {
            class ApplicationAdminLabelPrinter
            implements PrintListener {
                ApplicationAdminLabelPrinter() {
                }

                public void prepare(PrintEvent e) {
                    Label targetLabel = (Label)e.getTarget();
                    PageState pageState = e.getPageState();
                    Application application = Application.getCurrentApplication((HttpServletRequest)pageState.getRequest());
                    Assert.exists((Object)application, (String)"application");
                    targetLabel.setLabel(application.getTitle() + " Administration");
                }
            }
            this.setTitle(new Label((PrintListener)new ApplicationAdminLabelPrinter()));
        } else {
            this.setTitle(new Label((PrintListener)new CurrentApplicationLabelPrinter()));
        }
    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.setClassAttr("portalNavbar");
        navbar.add((Component)new Link((PrintListener)new ParentApplicationLinkPrinter()));
        navbar.add((Component)new Link((PrintListener)new CurrentApplicationLinkPrinter()));
        this.getHeader().add((Component)navbar);
    }

    protected void buildGlobal(Container global) {
        Link link = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.sign_out")), "/register/logout");
        link.setClassAttr("signoutLink");
        this.getGlobal().add((Component)link);
    }

    protected void buildHeader(Container header) {
        if (this.m_view != null) {
            if (this.m_view.equals("user")) {
                this.m_viewLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.faq.ui.admin_view")), "./admin/index.jsp"){

                    public boolean isVisible(PageState ps) {
                        return BookmarkBasePage.this.userIsAdmin(ps);
                    }
                };
            } else if (this.m_view.equals("admin")) {
                this.m_viewLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.faq.ui.user_view")), "../index.jsp");
            }
        }
        if (this.m_viewLink != null) {
            this.m_viewLink.setClassAttr("portalControl");
            header.add((Component)this.m_viewLink);
        }
    }

    protected void buildBody(Container body) {
    }

    protected void buildFooter(Container footer) {
    }

    public void goModal(PageState ps, Component c) {
        Component old = this.getSelected(ps);
        if (old != null) {
            old.setVisible(ps, false);
        }
        c.setVisible(ps, true);
        this.setSelected(ps, c);
    }

    private Component getSelected(PageState ps) {
        Integer stateIndex = (Integer)ps.getValue((ParameterModel)this.m_selected);
        Component c = null;
        if (stateIndex != null) {
            c = this.getComponent(stateIndex);
        }
        return c;
    }

    private void setSelected(PageState ps, Component c) {
        if (c == null) {
            ps.setValue((ParameterModel)this.m_selected, null);
        } else {
            ps.setValue((ParameterModel)this.m_selected, (Object)new Integer(this.stateIndex(c)));
        }
    }

    public void goUnmodal(PageState ps) {
        Component old = this.getSelected(ps);
        if (old != null) {
            old.setVisible(ps, false);
        }
        this.setSelected(ps, null);
    }

    private boolean userIsAdmin(PageState ps) {
        PermissionDescriptor permDescriptor = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)Application.getCurrentApplication((HttpServletRequest)ps.getRequest()), Kernel.getContext().getParty());
        return PermissionService.checkPermission((PermissionDescriptor)permDescriptor);
    }

    public void add(Component pc) {
        Assert.isUnlocked((Lockable)this);
        this.m_body.add(pc);
    }

    public Container getGlobal() {
        return this.m_global;
    }

    public Container getHeader() {
        return this.m_header;
    }

    public Container getBody() {
        return this.m_body;
    }

    public Container getFooter() {
        return this.m_footer;
    }

    protected class CurrentApplicationLabelPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Label label = (Label)e.getTarget();
            PageState pageState = e.getPageState();
            Application app = Application.getCurrentApplication((HttpServletRequest)pageState.getRequest());
            Assert.exists((Object)app, (String)"Application app");
            label.setLabel(app.getTitle());
        }
    }

    protected class ParentApplicationLinkPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            PageState pageState = e.getPageState();
            Application app = Application.getCurrentApplication((HttpServletRequest)pageState.getRequest());
            Assert.exists((Object)app, (String)"Application app");
            Application parent = app.getParentApplication();
            if (parent != null) {
                link.setChild((Component)new Label(parent.getTitle()));
                link.setTarget(parent.getPath());
            }
        }
    }

    protected class CurrentApplicationLinkPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            PageState pageState = e.getPageState();
            Application app = Application.getCurrentApplication((HttpServletRequest)pageState.getRequest());
            Assert.exists((Object)app, (String)"Application app");
            link.setChild((Component)new Label(app.getTitle()));
            link.setTarget(app.getPrimaryURL());
        }
    }

    private class Panel
    extends SimpleContainer {
        private Panel() {
        }

        public void generateXML(PageState ps, Element p) {
            Component selected = BookmarkBasePage.this.getSelected(ps);
            if (selected == null) {
                super.generateXML(ps, p);
            } else {
                SimpleContainer fakeBody = new SimpleContainer(BookmarkBasePage.BMRK_BODY_ELEMENT, BookmarkBasePage.BMRK_XML_NS);
                fakeBody.add(selected);
                Element parent = this.generateParent(p);
                BookmarkBasePage.this.m_header.generateXML(ps, parent);
                fakeBody.generateXML(ps, parent);
                BookmarkBasePage.this.m_footer.generateXML(ps, parent);
            }
        }
    }
}

