/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bookmarks.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.DynamicListWizard;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bookmarks.Bookmark;
import com.arsdigita.bookmarks.BookmarkCollection;
import com.arsdigita.bookmarks.Bookmarks;
import com.arsdigita.bookmarks.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.util.TooManyListenersException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class BookmarkEditPane
extends DynamicListWizard {
    public static final String EVENT_SWAP_UP = "swapUp";
    public static final String EVENT_SWAP_DOWN = "swapDown";
    final ModalContainer m_editContainer = new ModalContainer();
    SimpleContainer m_mainDisplay;
    EditBookmarkForm m_editBmrkForm;
    DeleteForm m_deleteForm;
    RequestLocal m_prtlRL;

    public BookmarkEditPane() {
        super("Current Bookmarks", new ListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                return new BmrkListModel(ps);
            }

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }
        }, "Add a new Bookmark", (Component)new Label(GlobalizationUtil.globalize("bookmarks.ui.select_a_bookmark_for_editing")));
        final BookmarkEditPane dlw = this;
        this.m_prtlRL = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                return (Bookmarks)Application.getCurrentApplication((HttpServletRequest)ps.getRequest());
            }
        };
        Form addForm = new Form("addBookmark", (Container)new GridPanel(2));
        addForm.add((Component)new Label(GlobalizationUtil.globalize("bookmarks.ui.name_of_new_bookmark")));
        final TextField newBmrkName = new TextField("name");
        newBmrkName.getParameterModel().addParameterListener((ParameterListener)new NotNullValidationListener("Choose a name for the new Bookmark"));
        addForm.add((Component)newBmrkName);
        addForm.add((Component)new Label(GlobalizationUtil.globalize("bookmarks.ui.new_bookmark_url")));
        final TextField newBmrkURL = new TextField("url");
        newBmrkURL.getParameterModel().addParameterListener((ParameterListener)new NotEmptyValidationListener("White space is not allowed in URLs"));
        addForm.add((Component)newBmrkURL);
        addForm.add((Component)new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_description")));
        final TextArea bmrkDesc = new TextArea("BmrkDesc");
        bmrkDesc.getParameterModel().addParameterListener((ParameterListener)new NotNullValidationListener("Enter a description for the new Bookmark"));
        addForm.add((Component)bmrkDesc);
        addForm.add((Component)new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_in_new_window")));
        final RadioGroup bmrkNewWin = new RadioGroup("newWin");
        bmrkNewWin.addOption(new Option("true", "Yes"));
        bmrkNewWin.addOption(new Option("false", "No"));
        addForm.add((Component)bmrkNewWin);
        addForm.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) {
                FormData data = e.getFormData();
                data.put((Object)"newWin", (Object)"false");
            }
        });
        addForm.add((Component)new Submit("Create Bookmark"));
        addForm.addValidationListener(new FormValidationListener(){

            public void validate(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                Bookmarks ba = (Bookmarks)((Object)BookmarkEditPane.this.m_prtlRL.get(ps));
                ba.assertPrivilege(PrivilegeDescriptor.CREATE);
            }
        });
        addForm.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                final Bookmarks ba = (Bookmarks)((Object)BookmarkEditPane.this.m_prtlRL.get(ps));
                final Bookmark newBmrk = new Bookmark(newBmrkName.getValue(ps).toString(), newBmrkURL.getValue(ps).toString());
                newBmrk.setDescription(bmrkDesc.getValue(ps).toString());
                newBmrk.setBookmarkApplication(ba);
                newBmrk.setNewWindow("true".equals(bmrkNewWin.getValue(ps)));
                newBmrk.setSortKey(Integer.MAX_VALUE);
                newBmrk.save();
                ba.normalizeBookmarkSortKeys();
                new KernelExcursion(){

                    protected void excurse() {
                        this.setParty(Kernel.getSystemParty());
                        PermissionService.setContext((ACSObject)newBmrk, (ACSObject)ba);
                        newBmrk.save();
                    }
                }.run();
                dlw.getListOfComponents().getSelectionModel().setSelectedKey(ps, (Object)newBmrk.getID().toString());
            }
        });
        this.setAddPane((Component)addForm);
        this.m_mainDisplay = new BoxPanel(2);
        this.m_editBmrkForm = new EditBookmarkForm(new GridPanel(2));
        this.m_mainDisplay.add((Component)this.m_editBmrkForm);
        ActionLink deleteLink = new ActionLink((String)GlobalizationUtil.globalize("bookmarks.ui.delete_this_bookmark").localize());
        deleteLink.setClassAttr("actionLink");
        deleteLink.addActionListener((ActionListener)new DeleteLinkListener());
        this.m_mainDisplay.add((Component)deleteLink);
        this.m_deleteForm = new DeleteForm();
        this.m_editContainer.add((Component)this.m_mainDisplay);
        this.m_editContainer.add((Component)this.m_deleteForm);
        this.setEditPane((Component)this.m_editContainer);
        ((List)this.getListingComponent()).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                ev.getPageState().reset((Component)BookmarkEditPane.this.m_editContainer);
            }
        });
        ((List)this.getListingComponent()).setCellRenderer(new ListCellRenderer(){

            public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
                Bookmarks app = (Bookmarks)Web.getContext().getApplication();
                BookmarkCollection bColl = app.getBookmarks();
                long size = bColl.size();
                bColl.close();
                SimpleContainer container = new SimpleContainer();
                Label name = new Label(value.toString(), false);
                if (isSelected) {
                    final String fKey = key;
                    if (index > 0) {
                        ControlLink upLink = new ControlLink("up"){

                            public void setControlEvent(PageState s) {
                                s.setControlEvent((Component)dlw, BookmarkEditPane.EVENT_SWAP_UP, fKey);
                            }
                        };
                        container.add((Component)upLink);
                        upLink.setClassAttr("shiftUp");
                        container.add((Component)new Label("&nbsp;&nbsp;", false));
                    }
                    name.setFontWeight("b");
                    container.add((Component)name);
                    if ((long)index < size - 1L) {
                        container.add((Component)new Label("&nbsp;&nbsp;", false));
                        ControlLink downLink = new ControlLink("down"){

                            public void setControlEvent(PageState s) {
                                s.setControlEvent((Component)dlw, BookmarkEditPane.EVENT_SWAP_DOWN, fKey);
                            }
                        };
                        downLink.setClassAttr("shiftDown");
                        container.add((Component)downLink);
                    }
                } else {
                    ControlLink l = new ControlLink((Component)name);
                    container.add((Component)l);
                }
                return container;
            }
        });
    }

    public void respond(PageState state) throws ServletException {
        String name = state.getControlEventName();
        String bIDstr = state.getControlEventValue();
        if (EVENT_SWAP_UP.equals(name)) {
            BigDecimal bID = new BigDecimal(bIDstr);
            Bookmark b = Bookmark.retrieveBookmark(bID);
            Bookmarks bApp = b.getBookmarkApplication();
            bApp.swapBookmarkWithPrevious(b);
        } else if (EVENT_SWAP_DOWN.equals(name)) {
            BigDecimal bID = new BigDecimal(bIDstr);
            Bookmark b = Bookmark.retrieveBookmark(bID);
            Bookmarks bApp = b.getBookmarkApplication();
            bApp.swapBookmarkWithNext(b);
        } else {
            super.respond(state);
        }
    }

    private class DeleteLinkListener
    implements ActionListener {
        private DeleteLinkListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PageState ps = event.getPageState();
            BookmarkEditPane.this.m_editContainer.setVisibleComponent(ps, (Component)BookmarkEditPane.this.m_deleteForm);
        }
    }

    public class DeleteForm
    extends Form
    implements FormProcessListener {
        private TextField currenttabName;
        private Label instruction;
        private Submit button;
        private Submit cancelbutton;

        public DeleteForm() {
            super("deletetabform");
            this.instruction = new Label(GlobalizationUtil.globalize("bookmarks.ui.are_you_sure_you_want_to_delete_this_bookmark"));
            this.instruction.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    String prefixstr = "Are you sure you want to delete the ";
                    BigDecimal bmrkID = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bmrkID);
                    Label t = (Label)e.getTarget();
                    t.setLabel(prefixstr + bmrk.getName() + " Bookmark?");
                }
            });
            this.button = new Submit("Delete this Bookmark");
            this.button.setButtonLabel("Delete this Bookmark");
            this.cancelbutton = new Submit("Cancel");
            this.cancelbutton.setButtonLabel("Cancel");
            Label spacer = new Label(" ");
            this.add((Component)this.instruction);
            this.add((Component)spacer);
            this.add((Component)this.button);
            this.add((Component)this.cancelbutton);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (this.button.isSelected(s)) {
                BigDecimal bmrkID = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                Bookmark bmrk = Bookmark.retrieveBookmark(bmrkID);
                Bookmarks bmrkapp = (Bookmarks)Application.getCurrentApplication((HttpServletRequest)s.getRequest());
                bmrkapp.removeBookmark(bmrk);
                BookmarkEditPane.this.getSelectionModel().clearSelection(s);
                BookmarkEditPane.this.reset(s);
            }
            s.reset((Component)BookmarkEditPane.this.m_editContainer);
        }
    }

    public class EditBookmarkForm
    extends Form
    implements FormProcessListener {
        private TextField bookmarkName;
        private TextField bookmarkURL;
        private TextArea bookmarkDescription;
        private Label instruction;
        private Label blank;
        private Label instruction1;
        private Label instruction2;
        private Label instruction3;
        private Label creationDateLabel;
        private Label creationDate;
        private Label modDateLabel;
        private Label modDate;
        private Label authorLabel;
        private Label author;
        private Label visitsLabel;
        private Label visits;
        private Label blank1;
        private Label blank2;
        private Label blank3;
        private Label blank4;
        private Submit button;
        private Label newWindowLabel;
        private RadioGroup newWindow;

        public EditBookmarkForm(GridPanel gp) {
            super("editbookmarkform", (Container)gp);
            this.instruction = new Label(GlobalizationUtil.globalize("bookmarks.ui.edit_fields_and_click_save_button"));
            this.blank = new Label(" ");
            this.instruction1 = new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_name"));
            this.instruction2 = new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_url"));
            this.instruction3 = new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_description"));
            this.blank1 = new Label("");
            this.blank2 = new Label("");
            this.blank3 = new Label("");
            this.blank4 = new Label("");
            this.creationDateLabel = new Label(GlobalizationUtil.globalize("bookmarks.ui.creation_date"));
            this.modDateLabel = new Label(GlobalizationUtil.globalize("bookmarks.ui.last_modified_date"));
            this.authorLabel = new Label(GlobalizationUtil.globalize("bookmarks.ui.created_by"));
            this.visitsLabel = new Label(GlobalizationUtil.globalize("bookmarks.ui.number_of_visits"));
            this.bookmarkName = new TextField("BookmarkName");
            this.bookmarkName.setDefaultValue((Object)"");
            this.bookmarkName.addValidationListener((ParameterListener)new NotNullValidationListener("Every Bookmark must have a name!"));
            this.newWindowLabel = new Label(GlobalizationUtil.globalize("bookmarks.ui.bookmark_in_new_window"));
            this.newWindow = new RadioGroup("newWin");
            this.newWindow.addOption(new Option("true", "Yes"));
            this.newWindow.addOption(new Option("false", "No"));
            try {
                this.newWindow.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent e) {
                        PageState s = e.getPageState();
                        if (BookmarkEditPane.this.getSelectionModel().isSelected(s)) {
                            BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                            RadioGroup group = (RadioGroup)e.getTarget();
                            group.setValue(s, (Object)String.valueOf(bmrk.getNewWindow()));
                        }
                    }
                });
            }
            catch (TooManyListenersException e) {
                // empty catch block
            }
            try {
                this.bookmarkName.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent e) {
                        PageState s = e.getPageState();
                        if (BookmarkEditPane.this.getSelectionModel().isSelected(s)) {
                            BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                            TextField tf = (TextField)e.getTarget();
                            tf.setValue(s, (Object)bmrk.getName());
                        }
                    }
                });
            }
            catch (TooManyListenersException e) {
                // empty catch block
            }
            this.bookmarkURL = new TextField("BookmarkURL");
            this.bookmarkURL.setDefaultValue((Object)"");
            this.bookmarkURL.addValidationListener((ParameterListener)new NotEmptyValidationListener("White space is not allowed in URLs!"));
            try {
                this.bookmarkURL.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent e) {
                        PageState s = e.getPageState();
                        if (BookmarkEditPane.this.getSelectionModel().isSelected(s)) {
                            BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                            TextField tf = (TextField)e.getTarget();
                            tf.setValue(s, (Object)bmrk.getURL());
                        }
                    }
                });
            }
            catch (TooManyListenersException e) {
                // empty catch block
            }
            this.bookmarkDescription = new TextArea("Description");
            this.bookmarkDescription.setDefaultValue((Object)"");
            try {
                this.bookmarkDescription.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent e) {
                        PageState s = e.getPageState();
                        if (BookmarkEditPane.this.getSelectionModel().isSelected(s)) {
                            BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                            TextArea ta = (TextArea)e.getTarget();
                            ta.setValue(s, (Object)bmrk.getDescription());
                        }
                    }
                });
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
            this.creationDate = new Label(GlobalizationUtil.globalize("bookmarks.ui.creation_date"));
            this.creationDate.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                    Label t = (Label)e.getTarget();
                    t.setLabel(bmrk.getCreateDate());
                }
            });
            this.modDate = new Label(GlobalizationUtil.globalize("bookmarks.ui.modification_date"));
            this.modDate.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                    Label t = (Label)e.getTarget();
                    t.setLabel(bmrk.getModDate());
                }
            });
            this.author = new Label(GlobalizationUtil.globalize("bookmarks.ui.creator"));
            this.author.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                    Label t = (Label)e.getTarget();
                    t.setLabel(bmrk.getAuthor());
                }
            });
            this.visits = new Label(GlobalizationUtil.globalize("bookmarks.ui.number_of_visits"));
            this.visits.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
                    Bookmark bmrk = Bookmark.retrieveBookmark(bd);
                    Label t = (Label)e.getTarget();
                    t.setLabel(bmrk.getNumVisits());
                }
            });
            this.button = new Submit("Save");
            this.button.setButtonLabel("Update Properties");
            this.add((Component)this.instruction);
            this.add((Component)this.blank);
            this.add((Component)this.instruction1);
            this.add((Component)this.bookmarkName);
            this.add((Component)this.instruction2);
            this.add((Component)this.bookmarkURL);
            this.add((Component)this.instruction3);
            this.add((Component)this.bookmarkDescription);
            this.add((Component)this.newWindowLabel);
            this.add((Component)this.newWindow);
            this.add((Component)this.blank1);
            this.add((Component)this.blank2);
            this.add((Component)this.creationDateLabel);
            this.add((Component)this.creationDate);
            this.add((Component)this.authorLabel);
            this.add((Component)this.author);
            this.add((Component)this.modDateLabel);
            this.add((Component)this.modDate);
            this.add((Component)this.blank3);
            this.add((Component)this.blank4);
            this.add((Component)this.button);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            BigDecimal bd = new BigDecimal((String)BookmarkEditPane.this.getSelectionModel().getSelectedKey(s));
            Bookmark bmrk = Bookmark.retrieveBookmark(bd);
            Bookmarks ba = (Bookmarks)Application.getCurrentApplication((HttpServletRequest)s.getRequest());
            bmrk.setName(this.bookmarkName.getValue(s).toString());
            bmrk.setURL(this.bookmarkURL.getValue(s).toString());
            bmrk.setDescription(this.bookmarkDescription.getValue(s).toString());
            bmrk.setModDate();
            bmrk.setBookmarkApplication(ba);
            bmrk.setNewWindow("true".equals(this.newWindow.getValue(s)));
            bmrk.save();
        }
    }

    static class BmrkListModel
    implements ListModel {
        BookmarkCollection m_bmrks;
        Bookmark m_bmrk;

        public BmrkListModel(PageState s) {
            Bookmarks bmrkapp = (Bookmarks)Application.getCurrentApplication((HttpServletRequest)s.getRequest());
            this.m_bmrks = bmrkapp.getBookmarks();
        }

        public boolean next() {
            if (!this.m_bmrks.next()) {
                return false;
            }
            this.m_bmrk = this.m_bmrks.getBookmark();
            return true;
        }

        public Object getElement() {
            return this.m_bmrk.getName();
        }

        public String getKey() {
            return this.m_bmrk.getID().toString();
        }
    }
}

