/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz;

import com.arsdigita.atoz.AtoZConfig;
import com.arsdigita.atoz.AtoZGenerator;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.atoz.AtoZProviderType;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AtoZ
extends Application {
    private static final Logger logger = Logger.getLogger(AtoZ.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.atoz.AtoZ";
    public static final String PROVIDERS = "atozProviders";
    public static final String SORT_KEY = "sortKey";
    private static Set s_types = new HashSet();
    private static final AtoZConfig s_config = AtoZConfig.getConfig();

    public AtoZ(DataObject obj) {
        super(obj);
    }

    public AtoZ(OID oid) {
        super(oid);
    }

    public static AtoZConfig getConfig() {
        return s_config;
    }

    public void addProvider(AtoZProvider provider) {
        DataObject link = this.add(PROVIDERS, (DomainObject)provider);
    }

    public void removeProvider(AtoZProvider provider) {
        this.remove(PROVIDERS, (DomainObject)provider);
    }

    public DomainCollection getProviders() {
        DataCollection providers = (DataCollection)this.get(PROVIDERS);
        providers.addOrder("link.sortKey");
        return new DomainCollection(providers);
    }

    public AtoZGenerator[] getGenerators() {
        DataCollection providers = (DataCollection)this.get(PROVIDERS);
        ArrayList<AtoZGenerator> generators = new ArrayList<AtoZGenerator>();
        while (providers.next()) {
            AtoZProvider provider = (AtoZProvider)DomainObjectFactory.newInstance((DataObject)providers.getDataObject());
            generators.add(provider.getGenerator());
        }
        return generators.toArray(new AtoZGenerator[generators.size()]);
    }

    public static Element newElement(String name) {
        Assert.isTrue((name.indexOf(":") == -1 ? 1 : 0) != 0, (String)"name does not contain :");
        return new Element("atoz:" + name, "http://xmlns.redhat.com/atoz/1.0");
    }

    public static void registerProviderType(AtoZProviderType type) {
        s_types.add(type);
    }

    public static AtoZProviderType[] getProviderTypes() {
        return s_types.toArray(new AtoZProviderType[s_types.size()]);
    }

    public String getServletPath() {
        return "/ccm-atoz/files";
    }
}

