/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz;

import com.arsdigita.atoz.CategoryProvider;
import com.arsdigita.categorization.Category;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CategoryAlias
extends DomainObject {
    private static final Logger s_log = Logger.getLogger(CategoryAlias.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.atoz.CategoryAlias";
    public static final String ID = "id";
    public static final String PROVIDER = "provider";
    public static final String CATEGORY = "category";
    public static final String LETTER = "letter";
    public static final String TITLE = "title";

    public CategoryAlias() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected CategoryAlias(String type) {
        super(type);
    }

    public CategoryAlias(DataObject obj) {
        super(obj);
    }

    public CategoryAlias(OID oid) {
        super(oid);
    }

    public void setup(Category category, String letter, String title) {
        this.setCategory(category);
        this.setLetter(letter);
        this.setTitle(title);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew() && this.get(ID) == null) {
            this.set(ID, CategoryAlias.generateID());
        }
    }

    public CategoryProvider getProvider() {
        return (CategoryProvider)((Object)this.get(PROVIDER));
    }

    public Category getCategory() {
        return new Category((DataObject)this.get(CATEGORY));
    }

    public void setCategory(Category category) {
        this.set(CATEGORY, category);
    }

    public String getLetter() {
        return (String)this.get(LETTER);
    }

    public void setLetter(String letter) {
        this.set(LETTER, letter);
    }

    public String getTitle() {
        return (String)this.get(TITLE);
    }

    public void setTitle(String title) {
        this.set(TITLE, title);
    }

    static BigDecimal generateID() throws PersistenceException {
        try {
            return Sequences.getNextValue();
        }
        catch (SQLException e) {
            String errorMsg = "Unable to generate a unique ACSObject id.";
            s_log.error((Object)"Unable to generate a unique ACSObject id.");
            throw PersistenceException.newInstance((String)"Unable to generate a unique ACSObject id.", (Throwable)e);
        }
    }
}

