/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz;

import com.arsdigita.atoz.AtoZAtomicEntry;
import com.arsdigita.atoz.AtoZEntry;
import com.arsdigita.atoz.AtoZGeneratorAbstractImpl;
import com.arsdigita.atoz.CategoryProvider;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.util.ArrayList;

public class CategoryGenerator
extends AtoZGeneratorAbstractImpl {
    public CategoryGenerator(CategoryProvider provider) {
        super(provider);
    }

    @Override
    public AtoZEntry[] getEntries(String letter) {
        CategoryProvider provider = (CategoryProvider)this.getProvider();
        DataQuery entries = provider.getAtomicEntries();
        Filter f = entries.addFilter("sortKey like :sortKey");
        f.set("sortKey", (Object)(letter.toLowerCase() + "%"));
        entries.addOrder("sortKey");
        ArrayList<CategoryAtomicEntry> l = new ArrayList<CategoryAtomicEntry>();
        while (entries.next()) {
            l.add(new CategoryAtomicEntry(new OID((String)entries.get("objectType"), entries.get("id")), (String)entries.get("title"), (String)entries.get("description")));
        }
        return l.toArray(new AtoZEntry[l.size()]);
    }

    private class CategoryAtomicEntry
    implements AtoZAtomicEntry {
        private OID m_oid;
        private String m_title;
        private String m_description;

        public CategoryAtomicEntry(OID oid, String title, String description) {
            this.m_oid = oid;
            this.m_title = title;
            this.m_description = description;
        }

        @Override
        public String getTitle() {
            return this.m_title;
        }

        @Override
        public String getDescription() {
            return this.m_description;
        }

        @Override
        public String getLink() {
            ParameterMap map = new ParameterMap();
            map.setParameter("oid", this.m_oid.toString());
            URL here = Web.getContext().getRequestURL();
            return new URL(here.getScheme(), here.getServerName(), here.getServerPort(), "", "", "/redirect/", map).toString();
        }

        @Override
        public Element getContent() {
            return null;
        }
    }
}

