/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.AtoZGenerator;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.atoz.CategoryAlias;
import com.arsdigita.atoz.CategoryGenerator;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentType;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.navigation.DataCollectionDefinition;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.subsite.Site;
import com.arsdigita.subsite.Subsite;
import com.arsdigita.subsite.SubsiteContext;
import org.apache.log4j.Logger;

public class CategoryProvider
extends AtoZProvider {
    private static final Logger s_log = Logger.getLogger(CategoryProvider.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.atoz.CategoryProvider";
    public static final String IS_COMPOUND = "isCompound";
    public static final String IS_VISIBLE = "isVisible";
    public static final String BLACK_LIST = "atozBlackList";
    public static final String CT_BLACK_LIST = "atozContentTypeBlackList";
    public static final String ALIASES = "aliases";
    public static final String CT_TYPE_ID = "type_id";
    public static final String ATOMIC_ENTRIES = "com.arsdigita.atoz.getAtomicCategoryEntries";
    public static final String ATOMIC_ENTRIES_FOR_ROOT_CATEGORY = "com.arsdigita.atoz.getAtomicCategoryEntriesForRootCategory";
    public static final String FILTERED_ATOMIC_ENTRIES = "com.arsdigita.atoz.getAtomicFilteredCategoryEntries";
    public static final String FILTERED_ATOMIC_ENTRIES_FOR_ROOT_CATEGORY = "com.arsdigita.atoz.getAtomicFilteredCategoryEntriesForRootCategory";
    public static final String ALL_BLACK_LIST_TYPES = "com.arsdigita.atoz.getAllBlackListTypes";

    public CategoryProvider() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected CategoryProvider(String type) {
        super(type);
    }

    public CategoryProvider(DataObject obj) {
        super(obj);
    }

    public CategoryProvider(OID oid) {
        super(oid);
    }

    public void delete() {
        Category.clearRootForObject((ACSObject)this);
        super.delete();
    }

    public static CategoryProvider create(String title, String description, boolean isCompound) {
        CategoryProvider provider = new CategoryProvider();
        provider.setup(title, description, isCompound);
        return provider;
    }

    protected void setup(String title, String description, boolean isCompound) {
        super.setup(title, description);
        this.setCompound(isCompound);
    }

    public boolean isCompound() {
        return Boolean.TRUE.equals(this.get(IS_COMPOUND));
    }

    public void setCompound(boolean isCompound) {
        this.set(IS_COMPOUND, new Boolean(isCompound));
    }

    public void addAlias(Category cat, String letter, String title) {
        CategoryAlias alias = new CategoryAlias();
        alias.setup(cat, letter, title);
        this.add(ALIASES, alias);
    }

    public void removeAlias(CategoryAlias alias) {
        this.remove(ALIASES, alias);
    }

    public void addBlock(Category cat) {
        this.add(BLACK_LIST, (DomainObject)cat);
    }

    public void removeBlock(Category cat) {
        this.remove(BLACK_LIST, (DomainObject)cat);
    }

    public DomainCollection getAliases() {
        DataAssociation entries = (DataAssociation)this.get(ALIASES);
        return new DomainCollection((DataCollection)entries);
    }

    public DomainCollection getBlackList() {
        DataAssociation entries = (DataAssociation)this.get(BLACK_LIST);
        return new DomainCollection((DataCollection)entries);
    }

    public DomainCollection getContentTypeBlackList() {
        DataAssociation entries = (DataAssociation)this.get(CT_BLACK_LIST);
        return new DomainCollection((DataCollection)entries);
    }

    public static void excludeBlackListTypes(DataCollectionDefinition definition) {
        DataQuery types = SessionManager.getSession().retrieveQuery(ALL_BLACK_LIST_TYPES);
        while (types.next()) {
            String objectType = (String)types.get("objectType");
            s_log.debug((Object)("Excluding object type from DataCollection: " + objectType));
            definition.excludeSpecificObjectType(objectType);
        }
        types.close();
    }

    public DataQuery getAtomicEntries() {
        DataQuery cats = null;
        SubsiteContext subsiteContext = Subsite.getContext();
        boolean useSubsiteSpecificNavigationCategory = AtoZ.getConfig().useSubsiteSpecificNavigationCategory();
        boolean hasSite = subsiteContext.hasSite();
        boolean filterCats = AtoZ.getConfig().filterCategoryProviders();
        if (hasSite && useSubsiteSpecificNavigationCategory) {
            Site site = subsiteContext.getSite();
            Category root = site.getRootCategory();
            cats = filterCats ? SessionManager.getSession().retrieveQuery(FILTERED_ATOMIC_ENTRIES_FOR_ROOT_CATEGORY) : SessionManager.getSession().retrieveQuery(ATOMIC_ENTRIES_FOR_ROOT_CATEGORY);
            cats.setParameter("providerID", (Object)this.getID());
            cats.setParameter("rootCategoryID", (Object)root.getID());
        } else {
            cats = filterCats ? SessionManager.getSession().retrieveQuery(FILTERED_ATOMIC_ENTRIES) : SessionManager.getSession().retrieveQuery(ATOMIC_ENTRIES);
            cats.setParameter("providerID", (Object)this.getID());
        }
        return cats;
    }

    public Category getRootCategory() {
        return Category.getRootForObject((ACSObject)this);
    }

    public void setRootCategory(Category root) {
        Category.setRootForObject((ACSObject)this, (Category)root);
    }

    @Override
    public AtoZGenerator getGenerator() {
        return new CategoryGenerator(this);
    }

    public void addContentTypeBlock(ContentType contentType) {
        if (!this.isBlocked(contentType)) {
            this.add(CT_BLACK_LIST, (DomainObject)contentType);
        }
    }

    private boolean isBlocked(ContentType contentType) {
        DataAssociation da = (DataAssociation)this.get(CT_BLACK_LIST);
        DataAssociationCursor cursor = da.cursor();
        while (cursor.next()) {
            if (cursor.getDataObject().getOID() != contentType.getOID()) continue;
            cursor.close();
            return true;
        }
        cursor.close();
        return false;
    }

    public void removeContentTypeBlock(ContentType contentType) {
        if (this.isBlocked(contentType)) {
            this.remove(CT_BLACK_LIST, (DomainObject)contentType);
        }
    }
}

