/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz;

import com.arsdigita.atoz.AtoZAtomicEntry;
import com.arsdigita.atoz.AtoZEntry;
import com.arsdigita.atoz.AtoZGeneratorAbstractImpl;
import com.arsdigita.atoz.ItemProvider;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;

public class ItemGenerator
extends AtoZGeneratorAbstractImpl {
    public ItemGenerator(ItemProvider provider) {
        super(provider);
    }

    @Override
    public AtoZEntry[] getEntries(String letter) {
        ItemProvider provider = (ItemProvider)this.getProvider();
        DataQuery entries = provider.getAtomicEntries();
        Filter f = entries.addFilter("sortKey like :sortKey");
        f.set("sortKey", (Object)(letter.toLowerCase() + "%"));
        entries.addOrder("sortKey");
        ArrayList<ItemAtomicEntry> l = new ArrayList<ItemAtomicEntry>();
        while (entries.next()) {
            ContentItem live;
            ContentItem item;
            ContentBundle bundle = new ContentBundle(new BigDecimal(entries.get("id").toString()));
            if (bundle == null || (item = bundle.negotiate(DispatcherHelper.getRequest().getLocales())) == null || (live = item.getLiveVersion()) == null) continue;
            String description = live instanceof ContentPage ? ((ContentPage)live).getSearchSummary() : live.getName();
            String title = "";
            if (entries.get("aliasTitle") != null) {
                title = entries.get("aliasTitle").toString();
            }
            if (title.equals("")) {
                title = live.getDisplayName();
            }
            l.add(new ItemAtomicEntry(live.getOID(), title, description));
        }
        return l.toArray(new AtoZEntry[l.size()]);
    }

    private class ItemAtomicEntry
    implements AtoZAtomicEntry {
        private OID m_oid;
        private String m_title;
        private String m_description;

        public ItemAtomicEntry(OID oid, String title, String description) {
            this.m_oid = oid;
            this.m_title = title;
            this.m_description = description;
        }

        @Override
        public String getTitle() {
            return this.m_title;
        }

        @Override
        public String getDescription() {
            return this.m_description;
        }

        @Override
        public String getLink() {
            ParameterMap map = new ParameterMap();
            map.setParameter("oid", this.m_oid.toString());
            URL here = Web.getContext().getRequestURL();
            return new URL(here.getScheme(), here.getServerName(), here.getServerPort(), "", "", "/redirect/", map).toString();
        }

        @Override
        public Element getContent() {
            return null;
        }
    }
}

