/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.tools;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.london.util.Transaction;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.cmd.Program;
import com.arsdigita.web.Application;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Logger;

public class AtoZCreator
extends Program {
    private static final Logger s_log = Logger.getLogger(AtoZCreator.class);

    public AtoZCreator() {
        super("Add AtoZ instance", "1.0.0", "URL-FRAGMENT TITLE");
    }

    private void addAtoZ(String atozURL, String atozTitle) {
        if (!Application.isInstalled((String)"com.arsdigita.atoz.AtoZ", (String)("/" + atozURL + "/"))) {
            DomainObjectFactory.registerInstantiator((String)"com.arsdigita.atoz.AtoZ", (DomainObjectInstantiator)new DomainObjectInstantiator(){

                public DomainObject doNewInstance(DataObject dataObject) {
                    return new AtoZ(dataObject);
                }
            });
            Application app = Application.createApplication((String)"com.arsdigita.atoz.AtoZ", (String)atozURL, (String)atozTitle, null);
            app.save();
        } else {
            System.err.println("com.arsdigita.atoz.AtoZ already installed at " + atozURL);
            System.exit(1);
        }
    }

    protected void doRun(final CommandLine cmdLine) {
        new Transaction(){

            public void doRun() {
                new KernelExcursion(){

                    public void excurse() {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        String[] args = cmdLine.getArgs();
                        if (args.length == 2) {
                            String atozURL = args[0];
                            String atozTitle = args[1];
                            if (atozURL != null && atozURL.length() != 0 && atozTitle != null && atozTitle.length() != 0) {
                                AtoZCreator.this.addAtoZ(atozURL, atozTitle);
                            } else {
                                AtoZCreator.this.help(System.err);
                                System.exit(1);
                            }
                        } else {
                            AtoZCreator.this.help(System.err);
                            System.exit(1);
                        }
                    }
                }.run();
            }
        }.run();
    }

    public static void main(String[] args) {
        new AtoZCreator().run(args);
    }
}

