/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.atoz.ui.AtoZGlobalizationUtil;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Classes;
import org.apache.log4j.Logger;

public abstract class AbstractProviderForm
extends Form {
    private static final Logger LOGGER = Logger.getLogger(AbstractProviderForm.class);
    private final ACSObjectSelectionModel providerModel;
    private final Class providerType;
    private TextField title;
    private TextArea description;
    private final SaveCancelSection buttons;

    public AbstractProviderForm(String name, Class providerType, ACSObjectSelectionModel provider) {
        super(name, (Container)new ColumnPanel(2));
        this.setRedirecting(true);
        this.providerModel = provider;
        this.providerType = providerType;
        this.buttons = new SaveCancelSection((Container)new SimpleContainer());
        this.addWidgets();
        this.add((Component)this.buttons);
        this.addProcessListener(new ProviderProcessListener());
        this.addSubmissionListener(new ProviderSubmissionListener());
        this.addInitListener(new ProviderInitListener());
    }

    protected void addWidgets() {
        this.title = new TextField("title");
        this.title.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 200));
        this.title.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.title.setSize(80);
        this.description = new TextArea("description");
        this.description.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 4000));
        this.description.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.description.setCols(80);
        this.description.setRows(5);
        this.add((Component)new Label(AtoZGlobalizationUtil.globalize("atoz.ui.provider_title")));
        this.add((Component)this.title);
        this.add((Component)new Label(AtoZGlobalizationUtil.globalize("atoz.ui.provider_description")));
        this.add((Component)this.description);
    }

    protected void processWidgets(PageState state, AtoZProvider provider) {
        provider.setTitle((String)this.title.getValue(state));
        provider.setDescription((String)this.description.getValue(state));
    }

    protected void initWidgets(PageState state, AtoZProvider provider) {
        if (provider != null) {
            this.title.setValue(state, (Object)provider.getTitle());
            this.description.setValue(state, (Object)provider.getDescription());
        }
    }

    private class ProviderInitListener
    implements FormInitListener {
        public void init(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            AtoZProvider provider = (AtoZProvider)AbstractProviderForm.this.providerModel.getSelectedObject(state);
            if (provider == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"No provider available");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Loading provider " + provider.getOID()));
            }
            AbstractProviderForm.this.initWidgets(state, provider);
        }
    }

    private class ProviderProcessListener
    implements FormProcessListener {
        public void process(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            AtoZProvider provider = (AtoZProvider)AbstractProviderForm.this.providerModel.getSelectedObject(state);
            if (provider == null) {
                AtoZ atoz = (AtoZ)Kernel.getContext().getResource();
                Assert.exists((Object)((Object)atoz), AtoZ.class);
                provider = (AtoZProvider)((Object)Classes.newInstance((Class)AbstractProviderForm.this.providerType));
                atoz.addProvider(provider);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Creating provider " + provider.getOID()));
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Loading provider " + provider.getOID()));
            }
            AbstractProviderForm.this.processWidgets(state, provider);
            AbstractProviderForm.this.fireCompletionEvent(state);
        }
    }

    private class ProviderSubmissionListener
    implements FormSubmissionListener {
        public void submitted(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            if (AbstractProviderForm.this.buttons.getCancelButton().isSelected(state)) {
                AbstractProviderForm.this.fireCompletionEvent(state);
                throw new FormProcessException("cancel hit");
            }
        }
    }
}

