/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.atoz.AtoZProviderType;
import com.arsdigita.atoz.ui.admin.AbstractProviderForm;
import com.arsdigita.atoz.ui.admin.AtoZProviderTable;
import com.arsdigita.atoz.ui.admin.ProviderAdmin;
import com.arsdigita.atoz.ui.admin.ProviderCreateForm;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.util.Assert;
import java.util.HashMap;
import java.util.Map;

public class AdminPane
extends SimpleContainer {
    private static final String XMLNS = "http://xmlns.redhat.com/atoz/1.0";
    private ACSObjectSelectionModel m_provider;
    private Map m_providerCreateMap;
    private Map m_providerAdminMap;
    private AtoZProviderTable m_providerTable;
    private ProviderCreateForm m_createForm;

    public AdminPane(BigDecimalParameter provider) {
        super("atoz:adminPane", XMLNS);
        this.m_provider = new ACSObjectSelectionModel(provider);
        this.m_provider.addChangeListener((ChangeListener)new ProviderEditStart());
        this.m_providerTable = new AtoZProviderTable(this.m_provider);
        this.add((Component)this.m_providerTable);
        this.m_createForm = new ProviderCreateForm();
        this.m_createForm.addCompletionListener(new ProviderCreateComplete());
        this.add((Component)this.m_createForm);
        AtoZProviderType[] providers = AtoZ.getProviderTypes();
        this.m_providerCreateMap = new HashMap();
        this.m_providerAdminMap = new HashMap();
        for (int i = 0; i < providers.length; ++i) {
            ProviderAdmin admin = providers[i].createProviderAdmin(this.m_provider);
            admin.addCompletionListener(new ProviderAdminComplete((Component)admin));
            this.m_providerAdminMap.put(providers[i].getProvider(), admin);
            this.add((Component)admin);
            AbstractProviderForm create = providers[i].createProviderCreate(this.m_provider);
            create.addCompletionListener(new ProviderAdminComplete((Component)create));
            this.m_providerCreateMap.put(providers[i].getProvider(), create);
            this.add((Component)create);
        }
    }

    public void register(Page p) {
        super.register(p);
        for (ProviderAdmin admin : this.m_providerAdminMap.values()) {
            p.setVisibleDefault((Component)admin, false);
        }
        for (AbstractProviderForm create : this.m_providerCreateMap.values()) {
            p.setVisibleDefault((Component)create, false);
        }
    }

    private class ProviderAdminComplete
    implements ActionListener {
        private Component m_admin;

        public ProviderAdminComplete(Component admin) {
            this.m_admin = admin;
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            this.m_admin.setVisible(state, false);
            AdminPane.this.m_createForm.setVisible(state, true);
            AdminPane.this.m_providerTable.setVisible(state, true);
            AdminPane.this.m_provider.clearSelection(state);
        }
    }

    private class ProviderCreateComplete
    implements ActionListener {
        private ProviderCreateComplete() {
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            Class provider = AdminPane.this.m_createForm.getProviderType(state);
            Assert.exists((Object)provider, Class.class);
            AbstractProviderForm create = (AbstractProviderForm)((Object)AdminPane.this.m_providerCreateMap.get(provider));
            Assert.exists((Object)((Object)create), AbstractProviderForm.class);
            create.setVisible(state, true);
            AdminPane.this.m_createForm.setVisible(state, false);
            AdminPane.this.m_providerTable.setVisible(state, false);
        }
    }

    private class ProviderEditStart
    implements ChangeListener {
        private ProviderEditStart() {
        }

        public void stateChanged(ChangeEvent e) {
            PageState state = e.getPageState();
            AtoZProvider provider = (AtoZProvider)AdminPane.this.m_provider.getSelectedObject(state);
            if (provider == null) {
                return;
            }
            ProviderAdmin admin = (ProviderAdmin)((Object)AdminPane.this.m_providerAdminMap.get(((Object)((Object)provider)).getClass()));
            Assert.exists((Object)((Object)admin), ProviderAdmin.class);
            admin.setVisible(state, true);
            AdminPane.this.m_createForm.setVisible(state, false);
            AdminPane.this.m_providerTable.setVisible(state, false);
        }
    }
}

