/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.atoz.ui.AtoZGlobalizationUtil;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.LockableImpl;

public class AtoZProviderTable
extends Table
implements TableActionListener {
    private static final String EDIT = "edit";
    private static final String DELETE = "delete";
    private static final String TABLE_COL_DELETE = "table_col_delete";
    private static final String TABLE_COL_EDIT = "table_col_edit";
    private final ACSObjectSelectionModel selectedProvider;

    public AtoZProviderTable(ACSObjectSelectionModel provider) {
        this.selectedProvider = provider;
        this.setEmptyView((Component)new Label(AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.empty")));
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.add(new TableColumn(0, AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.provider_name").localize()));
        columnModel.add(new TableColumn(1, AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.description").localize()));
        columnModel.add(new TableColumn(2, AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.type").localize()));
        columnModel.add(new TableColumn(3, AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.edit").localize(), (Object)TABLE_COL_EDIT));
        columnModel.add(new TableColumn(4, AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.delete").localize(), (Object)TABLE_COL_DELETE));
        this.setModelBuilder(new AtoZTableModelBuilder());
        columnModel.get(3).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        columnModel.get(4).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent event) {
        PageState state = event.getPageState();
        OID providerId = OID.valueOf((String)event.getRowKey().toString());
        TableColumn column = this.getColumnModel().get(event.getColumn().intValue());
        if (TABLE_COL_EDIT.equals(column.getHeaderKey().toString())) {
            AtoZProvider provider = (AtoZProvider)DomainObjectFactory.newInstance((OID)providerId);
            this.selectedProvider.setSelectedObject(state, (DomainObject)provider);
        } else if (TABLE_COL_DELETE.equals(column.getHeaderKey().toString())) {
            AtoZProvider provider = (AtoZProvider)DomainObjectFactory.newInstance((OID)providerId);
            provider.delete();
            this.selectedProvider.clearSelection(state);
        }
    }

    public void headSelected(TableActionEvent event) {
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ControlLink link = new ControlLink((String)AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.delete").localize());
            link.setConfirmation((String)AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.delete.confirm").localize());
            return link;
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int col) {
            return new ControlLink((String)AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.edit").localize());
        }
    }

    private class AtoZTableModel
    implements TableModel {
        private final Table table;
        private final DomainCollection providers;

        public AtoZTableModel(Table table) {
            this.table = table;
            AtoZ atoz = (AtoZ)Kernel.getContext().getResource();
            this.providers = atoz.getProviders();
        }

        public int getColumnCount() {
            return this.table.getColumnModel().size();
        }

        public boolean nextRow() {
            return this.providers.next();
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((AtoZProvider)this.providers.getDomainObject()).getTitle();
                }
                case 1: {
                    return ((AtoZProvider)this.providers.getDomainObject()).getDescription();
                }
                case 2: {
                    return ((AtoZProvider)this.providers.getDomainObject()).getObjectType().getName();
                }
                case 3: {
                    return AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.edit").localize();
                }
                case 4: {
                    return AtoZGlobalizationUtil.globalize("atoz.ui.providers_table.delete").localize();
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.providers.getDomainObject().getOID();
        }
    }

    private class AtoZTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            return new AtoZTableModel(table);
        }
    }
}

