/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.ItemAlias;
import com.arsdigita.atoz.ItemProvider;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.io.IOException;

public class ItemProviderAliasList
extends SimpleContainer {
    private ACSObjectSelectionModel m_provider;
    private static final String DELETE = "delete";

    public ItemProviderAliasList(ACSObjectSelectionModel provider) {
        this.m_provider = provider;
    }

    public void respond(PageState state) {
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        if (DELETE.equals(key)) {
            ItemAlias alias = (ItemAlias)DomainObjectFactory.newInstance((OID)OID.valueOf((String)value));
            alias.delete();
        }
    }

    public void generateXML(PageState state, Element parent) {
        Element content = AtoZ.newElement("itemProviderAliasList");
        this.exportAttributes(content);
        ItemProvider provider = (ItemProvider)this.m_provider.getSelectedObject(state);
        DomainCollection entries = provider.getAliases();
        while (entries.next()) {
            ItemAlias alias = (ItemAlias)entries.getDomainObject();
            Element el = AtoZ.newElement("itemProviderAlias");
            el.addAttribute("letter", XML.format((Object)entries.get("letter")));
            el.addAttribute("title", XML.format((Object)entries.get("title")));
            el.addAttribute("itemName", XML.format((Object)alias.getContentItem().getDisplayName()));
            try {
                state.setControlEvent((Component)this, DELETE, alias.getOID().toString());
                el.addAttribute("deleteURL", state.stateAsURL());
                state.clearControlEvent();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("Could not add delete link.", (Throwable)ex);
            }
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(el);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk(entries.getDomainObject(), ItemProviderAliasList.class.getName());
            content.addContent(el);
        }
        parent.addContent(content);
    }
}

