/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.AtoZProviderType;
import com.arsdigita.atoz.ui.AtoZGlobalizationUtil;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Classes;

public class ProviderCreateForm
extends Form {
    private OptionGroup m_providerType;

    public ProviderCreateForm() {
        super("providerCreate", (Container)new SimpleContainer());
        this.setRedirecting(true);
        this.m_providerType = new SingleSelect("providers");
        this.m_providerType.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_providerType.addOption(new Option(null, "--Select one--"));
        AtoZProviderType[] providers = AtoZ.getProviderTypes();
        for (int i = 0; i < providers.length; ++i) {
            this.m_providerType.addOption(new Option(providers[i].getProvider().getName(), providers[i].getTitle()));
        }
        this.add((Component)new Label(AtoZGlobalizationUtil.globalize("atoz.ui.create_provider")));
        this.add((Component)this.m_providerType);
        this.add((Component)new Submit("create", (String)AtoZGlobalizationUtil.globalize("atoz.ui.provider.create").localize()));
        this.addProcessListener(new ProviderCreateProcess());
    }

    public Class getProviderType(PageState state) {
        String providerName = (String)this.m_providerType.getValue(state);
        if (providerName != null && !"".equals(providerName)) {
            Class provider = Classes.loadClass((String)providerName);
            Assert.exists((Object)provider, Class.class);
            return provider;
        }
        return null;
    }

    private class ProviderCreateProcess
    implements FormProcessListener {
        private ProviderCreateProcess() {
        }

        public void process(FormSectionEvent e) {
            PageState state = e.getPageState();
            if (ProviderCreateForm.this.getProviderType(state) != null) {
                ProviderCreateForm.this.fireCompletionEvent(state);
            }
        }
    }
}

