/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.contenttypes.GenericArticle;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class ESDService
extends GenericArticle {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.london.contenttypes.ESDService";
    public static final String SERVICE_CONTACT = "serviceContact";
    public static final String SERVICE_TIMES = "serviceTimes";

    public ESDService() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ESDService(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ESDService(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ESDService(DataObject obj) {
        super(obj);
    }

    public ESDService(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)this.getContentType(), ContentType.class);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Contact getContact() {
        DataObject dobj = (DataObject)this.get(SERVICE_CONTACT);
        if (dobj != null) {
            return (Contact)DomainObjectFactory.newInstance((DataObject)dobj);
        }
        return null;
    }

    public void setContact(Contact ct) {
        Assert.exists((Object)ct, Contact.class);
        this.setAssociation(SERVICE_CONTACT, (DomainObject)ct);
    }

    public String getServiceTimes() {
        return (String)this.get(SERVICE_TIMES);
    }

    public void setServiceTimes(String st) {
        this.set(SERVICE_TIMES, st);
    }
}

