/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.london.contenttypes.Contact;
import com.arsdigita.london.contenttypes.ESDService;
import com.arsdigita.london.contenttypes.ui.ESDServiceChooseContactStep;
import com.arsdigita.london.contenttypes.util.ContactGlobalizationUtil;
import com.arsdigita.london.contenttypes.util.ESDServiceGlobalizationUtil;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class ESDServiceContactsTable
extends Table
implements TableActionListener {
    private static final int GIVENNAME_COL_IDX = 0;
    private static final int FAMILYNAME_COL_IDX = 1;
    private static final int TYPE_COL_IDX = 2;
    private static final int CHOOSE_COL_IDX = 3;
    private static final String COL_CHOOSE_CONTACT = "Select";
    private ItemSelectionModel m_selService;
    private ESDServiceChooseContactStep m_parent;

    public ESDServiceContactsTable(ItemSelectionModel selService, ESDServiceChooseContactStep parent) {
        this.m_parent = parent;
        this.m_selService = selService;
        TableColumnModel model = this.getColumnModel();
        model.add(new TableColumn(0, (Object)new Label(ContactGlobalizationUtil.globalize((String)"london.contenttypes.ui.contact.givenname"))));
        model.add(new TableColumn(1, (Object)new Label(ContactGlobalizationUtil.globalize((String)"london.contenttypes.ui.contact.familyname"))));
        model.add(new TableColumn(2, (Object)new Label(ContactGlobalizationUtil.globalize((String)"london.contenttypes.ui.contact.type"))));
        model.add(new TableColumn(3, (Object)new Label(ESDServiceGlobalizationUtil.globalize("london.contenttypes.ui.esdservice.select_contact"))));
        this.setEmptyView((Component)new Label(ESDServiceGlobalizationUtil.globalize("london.contenttypes.ui.esdservice.no_contacts")));
        this.setModelBuilder(new ContactsTableModelBuilder());
        model.get(3).setCellRenderer((TableCellRenderer)new SelectCellRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent evt) {
        PageState state = evt.getPageState();
        TableColumn col = this.getColumnModel().get(evt.getColumn().intValue());
        if (3 == evt.getColumn()) {
            this.m_parent.showDisplayPane(state);
            BigDecimal contactID = new BigDecimal(evt.getRowKey().toString());
            ESDService service = (ESDService)this.m_selService.getSelectedObject(state);
            Contact ct = (Contact)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.london.contenttypes.Contact", (Object)contactID));
            service.setContact(ct);
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    private class SelectCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private SelectCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ControlLink link = new ControlLink((Component)value);
            link.setConfirmation(ESDServiceGlobalizationUtil.globalize("london.contenttypes.ui.esdservice.select_this_contact"));
            return link;
        }
    }

    private class ContactsTableModel
    implements TableModel {
        private Table m_table;
        private DataCollection m_contacts;
        private Contact m_contact;

        private ContactsTableModel(Table t, DataCollection cts) {
            this.m_table = t;
            this.m_contacts = cts;
        }

        public int getColumnCount() {
            return this.m_table.getColumnModel().size();
        }

        public boolean nextRow() {
            if (this.m_contacts.next()) {
                this.m_contact = (Contact)DomainObjectFactory.newInstance((DataObject)this.m_contacts.getDataObject());
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_contact.getGivenName();
                }
                case 1: {
                    return this.m_contact.getFamilyName();
                }
                case 2: {
                    return this.m_contact.getContactTypeName();
                }
                case 3: {
                    return new Label(ESDServiceGlobalizationUtil.globalize("london.contenttypes.ui.esdservice.select"));
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_contact.getID();
        }
    }

    private class ContactsTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ContactsTableModelBuilder() {
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            DataCollection m_contacts = SessionManager.getSession().retrieve("com.arsdigita.london.contenttypes.Contact");
            m_contacts.addEqualsFilter("version", (Object)"draft");
            return new ContactsTableModel(table, m_contacts);
        }
    }
}

