/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.xmlfeed;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.contenttypes.xmlfeed.listener.RetrieveListener;
import com.arsdigita.cms.formbuilder.FormItem;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentSubmit;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class XMLFeed
extends FormItem {
    private static Logger s_log = Logger.getLogger(XMLFeed.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.xmlfeed.XMLFeed";
    public static final String URL = "url";
    public static final String XSL_FILE = "xslFile";

    public XMLFeed() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public XMLFeed(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public XMLFeed(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public XMLFeed(DataObject xmlFeedDataObject) {
        super(xmlFeedDataObject);
    }

    public XMLFeed(String typeName) {
        super(typeName);
    }

    public String getURL() {
        return (String)this.get(URL);
    }

    public void setURL(String url) {
        this.set(URL, url);
    }

    public FileAsset getXSLFile() {
        DataObject dobj = (DataObject)this.get(XSL_FILE);
        if (null == dobj) {
            return null;
        }
        return (FileAsset)DomainObjectFactory.newInstance((DataObject)dobj);
    }

    public void setXSLFile(FileAsset xsl) {
        this.setAssociation(XSL_FILE, (DomainObject)xsl);
    }

    public Iterator getFormFieldNames() {
        Vector<String> names = new Vector<String>();
        DataAssociationCursor allFields = this.getForm().getComponents();
        while (allFields.next()) {
            PersistentComponent c = (PersistentComponent)DomainObjectFactory.newInstance((DataObject)allFields.getDataObject());
            if (!(c instanceof PersistentWidget) || c instanceof PersistentSubmit) continue;
            names.add(((PersistentWidget)c).getParameterName());
        }
        return names.iterator();
    }

    protected Form instantiateForm(PersistentForm pform, boolean readOnly) {
        Form form = super.instantiateForm(pform, readOnly);
        if (!readOnly) {
            form.addProcessListener((FormProcessListener)new RetrieveListener(this));
        }
        return form;
    }

    protected void generateXMLBody(PageState state, Element parent, Component c) {
        super.generateXMLBody(state, parent, c);
        String data = (String)state.getRequest().getAttribute("XML Feed Results");
        Element label = parent.newChildElement("bebop:label", "http://www.arsdigita.com/bebop/1.0");
        label.addAttribute("escape", "yes");
        label.setText(data);
    }
}

