/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.xmlfeed.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.xmlfeed.XMLFeed;
import com.arsdigita.cms.contenttypes.xmlfeed.util.XMLFeedGlobalizationUtil;
import com.arsdigita.cms.ui.FileUploadSection;
import com.arsdigita.cms.ui.SecurityPropertyEditor;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.templating.Templating;
import com.arsdigita.templating.XSLTemplate;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public final class XSLFileProperties
extends SecurityPropertyEditor
implements Resettable {
    private static Logger s_log = Logger.getLogger(XSLFileProperties.class);
    public static final String MIME_TYPE = "application/xsl+xml";
    public static final String FILE_UPLOAD = "file_upload";
    private AuthoringKitWizard m_parent;
    private ItemSelectionModel m_itemModel;

    public XSLFileProperties(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        this.m_itemModel = itemModel;
        this.m_parent = parent;
        XSLFilePropertiesForm form = new XSLFilePropertiesForm(itemModel);
        this.add(FILE_UPLOAD, XMLFeedGlobalizationUtil.globalize("cms.contenttypes.ui.xmlfeed.xsl_file_upload"), (ComponentAccess)new WorkflowLockedComponentAccess((Component)form, itemModel), form.getSaveCancelSection().getCancelButton());
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(XMLFeedGlobalizationUtil.globalize("cms.contenttypes.ui.xmlfeed.xsl_file"), "xslFile.name");
        this.setDisplayComponent((Component)sheet);
        this.getDisplayPane().setClassAttr("invertedPropertyDisplay");
    }

    public void reset(PageState state) {
        this.showDisplayPane(state);
    }

    public FileAsset getFileAsset(PageState state) {
        return (FileAsset)this.m_itemModel.getSelectedObject(state);
    }

    private FileAsset createFileAsset() {
        FileAsset file = new FileAsset();
        file.setMimeType(MimeType.loadMimeType((String)MIME_TYPE));
        return file;
    }

    private class XSLFilePropertiesForm
    extends Form
    implements FormProcessListener,
    FormValidationListener {
        private final ItemSelectionModel m_itemModel;
        private FileUploadSection m_fileUploadSection;
        private SaveCancelSection m_saveCancelSection;

        public XSLFilePropertiesForm(ItemSelectionModel itemModel) {
            super("XSLFileUpload", (Container)new ColumnPanel(2));
            this.setMethod("post");
            this.setEncType("multipart/form-data");
            this.m_fileUploadSection = new FileUploadSection(XMLFeedGlobalizationUtil.globalize("cms.contenttypes.ui.xmlfeed.xsl_file_type"), "application", XSLFileProperties.MIME_TYPE);
            this.m_fileUploadSection.getFileUploadWidget().addValidationListener((ParameterListener)new NotNullValidationListener());
            this.setMimeTypeOptions(this.m_fileUploadSection.getMimeTypeWidget());
            this.add((Component)this.m_fileUploadSection);
            this.m_itemModel = itemModel;
            this.m_saveCancelSection = new SaveCancelSection();
            this.add((Component)this.m_saveCancelSection);
            FormErrorDisplay errorDisplay = new FormErrorDisplay((Form)this);
            this.add((Component)errorDisplay);
            ColumnPanel panel = (ColumnPanel)this.getPanel();
            panel.setBorder(false);
            panel.setPadColor("#FFFFFF");
            panel.setColumnWidth(1, "20%");
            panel.setColumnWidth(2, "80%");
            panel.setWidth("2%");
            this.addProcessListener(this);
            this.addValidationListener(this);
        }

        private void setMimeTypeOptions(SingleSelect select) {
            select.clearOptions();
            select.addOption(new Option(XSLFileProperties.MIME_TYPE, "XSL File"));
            select.setOptionSelected(XSLFileProperties.MIME_TYPE);
        }

        public SaveCancelSection getSaveCancelSection() {
            return this.m_saveCancelSection;
        }

        public FileUploadSection getFileUploadSection() {
            return this.m_fileUploadSection;
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            PageState state = e.getPageState();
            XMLFeed item = (XMLFeed)this.m_itemModel.getSelectedObject(state);
            FileAsset fileAsset = item.getXSLFile();
            if (null == fileAsset) {
                fileAsset = XSLFileProperties.this.createFileAsset();
                item.setXSLFile(fileAsset);
            }
            File file = this.m_fileUploadSection.getFile(e);
            String fileName = this.m_fileUploadSection.getFileName(e);
            fileAsset.setMimeType(this.m_fileUploadSection.getMimeType(e));
            try {
                fileAsset.loadFromFile(fileName, file, XSLFileProperties.MIME_TYPE);
            }
            catch (IOException ex) {
                throw new FormProcessException("cannot load XSL file", (Throwable)ex);
            }
            fileAsset.setName(fileName);
            item.save();
        }

        public void validate(FormSectionEvent e) throws FormProcessException {
            boolean isCorrectType;
            FormData data = e.getFormData();
            File file = this.m_fileUploadSection.getFile(e);
            try {
                URL url = new URL("file://" + file.getAbsolutePath());
                XSLTemplate xsl = Templating.getTemplate((URL)url);
            }
            catch (UncheckedWrapperException ex) {
                s_log.error((Object)"cannot instantiate XSL file", (Throwable)ex);
                data.addError(XMLFeedGlobalizationUtil.globalize("cms.contenttypes.ui.xmlfeed.xsl_file_validation_error"));
            }
            catch (MalformedURLException ex) {
                throw new UncheckedWrapperException("bad filename " + file, (Throwable)ex);
            }
            MimeType mime = this.m_fileUploadSection.getMimeType(e);
            if (mime != null && !(isCorrectType = XSLFileProperties.MIME_TYPE.equals(mime.getPrefix()))) {
                data.addError(XMLFeedGlobalizationUtil.globalize("cms.contenttypes.ui.xmlfeed.xsl_file_type_error"));
            }
        }
    }
}

