/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo;

import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.InvalidNameException;
import com.arsdigita.docrepo.Resource;
import com.arsdigita.docrepo.ResourceException;
import com.arsdigita.docrepo.ResourceExistsException;
import com.arsdigita.docrepo.ResourceImpl;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;
import java.util.StringTokenizer;

public class Folder
extends ResourceImpl {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.docrepo.Folder";

    public Folder() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Folder(DataObject dataObject) {
        super(dataObject);
    }

    public Folder(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Folder(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Folder(String objectTypeString) {
        super(objectTypeString);
    }

    protected Folder(ObjectType type) {
        super(type);
    }

    public Folder(String name, String description) {
        super(BASE_DATA_OBJECT_TYPE, name, description);
    }

    public Folder(String name, String description, Folder parent) {
        super(BASE_DATA_OBJECT_TYPE);
        if (parent.hasResource(name)) {
            throw new ResourceExistsException("A resource named " + name + " exists in the parent folder " + parent.getName());
        }
        this.setParent(parent);
        this.setName(name);
        this.setDescription(description);
    }

    @Override
    protected void beforeSave() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"folder before save");
        }
        this.set("isFolder", Boolean.TRUE);
        super.beforeSave();
    }

    @Override
    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    @Override
    public void setParent(Resource parent) {
        if (parent instanceof Folder) {
            String parentPath = parent.getPath();
            String path = this.getPath();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("folder set parent Parent path: " + parentPath + " folder path: " + path));
            }
            if (path != null && parentPath.startsWith(path)) {
                throw new ResourceException("The parent is a child of this folder. Parent path: " + parentPath + " folder path: " + path);
            }
        }
        super.setParent(parent);
    }

    public Folder retrieveFolder(String path) throws DataObjectNotFoundException, InvalidNameException {
        return new Folder(this.getResourceID(path));
    }

    public File retrieveFile(String path) throws DataObjectNotFoundException, InvalidNameException {
        return new File(this.getResourceID(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResource(String name) {
        DataAssociation da = (DataAssociation)this.get("immediateChildren");
        DomainCollection resources = new DomainCollection((DataCollection)da);
        resources.addEqualsFilter("name", (Object)name);
        try {
            boolean bl = resources.next();
            return bl;
        }
        finally {
            resources.close();
        }
    }

    public Folder createFolders(String path) throws InvalidNameException, ResourceExistsException {
        int pec = Folder.isValidPath(path);
        if (pec != 0) {
            throw new InvalidNameException(pec);
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        int pathElementCount = st.countTokens();
        String[] name = new String[pathElementCount];
        for (int i = 0; i < pathElementCount; ++i) {
            name[i] = st.nextToken();
        }
        String[] subPath = new String[pathElementCount];
        for (int i = 0; i < pathElementCount; ++i) {
            StringBuilder buf = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                buf.append("/");
                buf.append(name[j]);
            }
            subPath[i] = buf.toString();
        }
        Folder[] folder = new Folder[pathElementCount];
        int lastPathElementIndex = pathElementCount - 1;
        int retrievedFolderIndex = -1;
        for (retrievedFolderIndex = lastPathElementIndex; retrievedFolderIndex >= 0; --retrievedFolderIndex) {
            try {
                folder[retrievedFolderIndex] = this.retrieveFolder(subPath[retrievedFolderIndex].substring(1));
                break;
            }
            catch (DataObjectNotFoundException ex) {
                continue;
            }
        }
        if (retrievedFolderIndex == lastPathElementIndex) {
            throw new ResourceExistsException("createFolders: folder exists:" + path);
        }
        Folder parent = retrievedFolderIndex < 0 ? this : folder[retrievedFolderIndex];
        for (int i = retrievedFolderIndex + 1; i < pathElementCount; ++i) {
            folder[i] = new Folder(name[i], null, parent);
            folder[i].save();
            parent = folder[i];
        }
        return folder[lastPathElementIndex];
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public Resource copyTo(String name, Resource parent) {
        Folder dest = new Folder();
        Folder.copy(this, dest);
        dest.setName(name);
        dest.setParent(parent);
        dest.save();
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.docrepo.getDirectChildren");
        query.setParameter("parentID", (Object)this.getID());
        while (query.next()) {
            OID oid = new OID("com.arsdigita.docrepo.ResourceImpl", query.get("id"));
            try {
                ResourceImpl orig = (ResourceImpl)DomainObjectFactory.newInstance((OID)oid);
                orig.copyTo(dest);
            }
            catch (DataObjectNotFoundException ex) {
                throw new ResourceException((Exception)((Object)ex));
            }
        }
        return dest;
    }
}

