/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo;

import com.arsdigita.db.DbHelper;
import com.arsdigita.docrepo.DocBlobject;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.Repository;
import com.arsdigita.docrepo.ui.RecentUpdatedDocsPortlet;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;

public class Initializer
extends CompoundInitializer {
    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
        this.add((com.arsdigita.runtime.Initializer)new PDLInitializer((PDLSource)new ManifestSource("ccm-docrepo.pdl.mf", (PDLFilter)new NameFilter(DbHelper.getDatabaseSuffix((int)database), "pdl"))));
    }

    public void init(DomainInitEvent evt) {
        super.init(evt);
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.docrepo.Repository", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Repository(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.docrepo.ResourceImpl", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject obj) {
                Boolean isFolder = (Boolean)obj.get("isFolder");
                if (isFolder != null && isFolder.booleanValue()) {
                    return new Folder(obj);
                }
                return new File(obj);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.docrepo.File", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new File(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.docrepo.Folder", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Folder(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.docrepo.DocBlobject", (DomainObjectInstantiator)new DomainObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new DocBlobject(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.docrepo.ui.RecentUpdatedDocsPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new RecentUpdatedDocsPortlet(dataObject);
            }
        });
    }
}

