/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo;

import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.Resource;
import com.arsdigita.docrepo.ResourceImplCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Repository
extends Application {
    private static Logger s_log = Logger.getLogger(Repository.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.docrepo.Repository";
    private static final String ACTION = "action";
    public static final String CONTENT = "content";
    public static final String DESCRIPTION = "description";
    private static final String DURATION = "duration";
    private static final String FOLDER_ID = "folderID";
    public static final String IS_FOLDER = "isFolder";
    private static final String LAST_MODIFIED_DATE = "lastModifiedDate";
    private static final String MIME_TYPE_LABEL = "mimeTypeDescription";
    public static final String NAME = "name";
    private static final String OBJECT_ID = "objectID";
    public static final String PARENT = "parent";
    private static final String PARTY_ID = "partyID";
    public static final String PATH = "path";
    public static final String SIZE = "size";
    public static final String TYPE = "mimeType";
    private static final String USER_ID = "userID";
    private static final String OWNER = "ownerID";
    private static final String ROOT = "rootID";
    String REPOSITORIES_MOUNTED = "subscribedRepositories";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_HTML = "text/html";
    private Folder m_root = null;
    private boolean m_wasNew;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Repository(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Repository(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Repository(DataObject obj) {
        super(obj);
        if (obj.isNew()) {
            s_log.info((Object)"Create root folder for repository");
            this.m_root = new Folder(this.getID().toString(), null);
            this.m_root.save();
            obj.set(ROOT, (Object)this.m_root.getID());
            s_log.info((Object)("Created root folder for repository " + this.getID()));
        }
    }

    protected void beforeSave() {
        if (this.isNew()) {
            this.m_wasNew = true;
        }
        super.beforeSave();
    }

    protected void afterSave() {
        super.afterSave();
        if (this.m_wasNew) {
            KernelExcursion excursion = new KernelExcursion(){

                protected void excurse() {
                    this.setParty(Kernel.getSystemParty());
                    Assert.exists((Object)Repository.this.m_root, (String)"Folder m_root");
                    PermissionService.setContext((ACSObject)Repository.this.m_root, (ACSObject)Repository.this);
                }
            };
            excursion.run();
        }
    }

    public static Repository create(String urlName, String title, Application parent) {
        Repository repository = (Repository)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)urlName, (String)title, (Application)parent);
        repository.save();
        return repository;
    }

    private void setName(String name) {
        this.set(NAME, name);
    }

    private void setOwner(BigDecimal ownerID) {
        this.set(OWNER, ownerID);
    }

    public static Resource retrieveResource(String absPath) {
        throw new UnsupportedOperationException();
    }

    private static void assertParty(Party party) {
        BigDecimal id = party.getID();
        if (id == null) {
            throw new RuntimeException("User not peristent");
        }
    }

    public Party getOwner() {
        BigDecimal id = (BigDecimal)this.get(OWNER);
        User party = null;
        if (id != null) {
            try {
                party = User.retrieve((BigDecimal)id);
            }
            catch (DataObjectNotFoundException e1) {
                try {
                    party = new Group(id);
                }
                catch (DataObjectNotFoundException e2) {
                    throw new RuntimeException("No User or Group found.");
                }
            }
        }
        return party;
    }

    public Folder getRoot() {
        BigDecimal id = (BigDecimal)this.get(ROOT);
        Folder root = null;
        try {
            root = new Folder(id);
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException("Repository root folder does not exist");
        }
        return root;
    }

    public static ResourceImplCollection getRecentlyModifiedDocuments() {
        HttpServletRequest req = Web.getRequest();
        Repository rep = Repository.getCurrentRepository(req);
        DataCollection dataCollection = SessionManager.getSession().retrieve("com.arsdigita.docrepo.ResourceImpl");
        dataCollection.addFilter(dataCollection.getFilterFactory().startsWith(PATH, rep.getRoot().getPath(), true));
        dataCollection.addEqualsFilter(IS_FOLDER, (Object)Boolean.FALSE);
        ResourceImplCollection rCollection = new ResourceImplCollection(dataCollection);
        return rCollection;
    }

    public static ResourceImplCollection getRecentlyModifiedDocuments(Repository rep) {
        DataCollection dataCollection = SessionManager.getSession().retrieve("com.arsdigita.docrepo.ResourceImpl");
        dataCollection.addFilter(dataCollection.getFilterFactory().startsWith(PATH, rep.getRoot().getPath(), true));
        dataCollection.addEqualsFilter(IS_FOLDER, (Object)Boolean.FALSE);
        ResourceImplCollection rCollection = new ResourceImplCollection(dataCollection);
        return rCollection;
    }

    public static Repository getCurrentRepository(HttpServletRequest req) {
        Application app = Application.getCurrentApplication((HttpServletRequest)req);
        if (app instanceof Repository) {
            return (Repository)app;
        }
        return null;
    }

    public String getServletPath() {
        return "/docrepo/";
    }
}

