/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo;

import com.arsdigita.db.Sequences;
import com.arsdigita.docrepo.InvalidNameException;
import com.arsdigita.docrepo.Resource;
import com.arsdigita.docrepo.ResourceNotEmptyException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.versioning.VersionedACSObject;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public abstract class ResourceImpl
extends VersionedACSObject
implements Resource {
    protected static Logger s_log = Logger.getLogger(ResourceImpl.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.docrepo.ResourceImpl";
    public static final String PARENT = "parent";
    private boolean m_wasNew;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected ResourceImpl() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected ResourceImpl(String typeName) {
        super(typeName);
    }

    protected ResourceImpl(ObjectType type) {
        super(type);
    }

    protected ResourceImpl(DataObject dataObject) {
        super(dataObject);
    }

    protected ResourceImpl(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected ResourceImpl(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected ResourceImpl(String type, String name, String description) {
        this(type);
        this.setName(name);
        this.setDescription(description);
    }

    protected ResourceImpl(String type, String name, String description, ResourceImpl parent) {
        this(type, name, description);
        this.setParent(parent);
    }

    protected ResourceImpl(String type, ResourceImpl parent) {
        this(type);
        this.setParent(parent);
    }

    protected void beforeSave() {
        User user;
        boolean pathChanged;
        this.m_wasNew = this.isNew();
        boolean bl = pathChanged = this.isPropertyModified(PARENT) || this.isPropertyModified("name");
        if (pathChanged) {
            Resource parent;
            String oldPath = null;
            if (!this.isNew()) {
                oldPath = this.getPath();
            }
            if ((parent = this.getParent()) != null) {
                String parentPath = parent.getPath();
                this.setPath(parentPath + "/" + this.getName());
            } else {
                this.setPath("/" + this.getName());
            }
            if (oldPath != null) {
                this.updateChildren(oldPath);
            }
        }
        if (this.isNew()) {
            user = Web.getContext().getUser();
            if (user != null) {
                this.setCreationUser(user);
                this.setLastModifiedUser(user);
            }
            Date date = new Date();
            this.setCreationDate(date);
            this.setLastModifiedDate(date);
            this.setCreationIP();
        } else {
            user = Web.getContext().getUser();
            if (user != null) {
                this.setLastModifiedUser(user);
            }
            this.setLastModifiedDate(new Date());
            this.setLastModifiedIP();
        }
        super.beforeSave();
    }

    protected void afterSave() {
        super.afterSave();
        if (this.m_wasNew && !this.isRoot()) {
            Resource obj = this.getParent();
            if (obj instanceof ACSObject) {
                PermissionService.setContext((ACSObject)this, (ACSObject)((ACSObject)obj));
            }
            new KernelExcursion(){

                protected void excurse() {
                    Party currentParty = Kernel.getContext().getParty();
                    this.setParty(Kernel.getSystemParty());
                    PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)ResourceImpl.this, currentParty));
                }
            }.run();
        }
    }

    public void delete() throws ResourceNotEmptyException {
        String name = this.getName();
        String suffix = "";
        try {
            suffix = "-" + Sequences.getNextValue();
        }
        catch (SQLException se) {
            throw new PersistenceException(se.getMessage());
        }
        int suffixLength = suffix.length();
        int nameLength = name.length();
        if (nameLength > suffixLength) {
            this.setName(name.substring(0, nameLength - suffixLength) + suffix);
        } else {
            this.setName(name + suffix);
        }
        this.save();
        try {
            super.delete();
        }
        catch (PersistenceException ex) {
            throw new ResourceNotEmptyException(ex.getMessage());
        }
    }

    private void updateChildren(String oldPath) {
        String path = this.getPath();
        s_log.debug((Object)("Running updateChildren for ID " + this.getID() + " on path " + path));
        Session session = SessionManager.getSession();
        DataOperation op = session.retrieveDataOperation("com.arsdigita.docrepo.updateChildren");
        op.setParameter("rootPath", (Object)path);
        op.setParameter("oldPath", (Object)oldPath);
        op.setParameter("oldRootPathLength", (Object)new Integer(oldPath.length() + 1));
        op.setParameter("parentResource", (Object)this.getID());
        op.execute();
        op.close();
    }

    @Override
    public String getName() {
        return (String)this.get("name");
    }

    public void setName(String name) {
        this.set("name", name);
    }

    @Override
    public String getDescription() {
        return (String)this.get("description");
    }

    public void setDescription(String description) {
        this.set("description", description);
    }

    @Override
    public Resource getParent() {
        DataObject parent = (DataObject)this.get(PARENT);
        if (parent != null) {
            return (Resource)DomainObjectFactory.newInstance((DataObject)parent);
        }
        return null;
    }

    public void setParent(Resource parent) {
        this.set(PARENT, parent);
    }

    protected BigDecimal getParentResourceID() {
        Resource parent = this.getParent();
        if (parent != null) {
            return parent.getID();
        }
        return null;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public String getPath() {
        String path = (String)this.get("path");
        return path;
    }

    private void setPath(String path) {
        this.set("path", path);
    }

    @Override
    public abstract boolean isFolder();

    @Override
    public abstract boolean isFile();

    @Override
    public URL toURL() {
        throw new UnsupportedOperationException();
    }

    protected static String retrievePath(BigDecimal id) {
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        collection.addEqualsFilter("id", (Object)id);
        String ids = null;
        if (!collection.next()) {
            return "";
        }
        ids = (String)collection.get("path");
        collection.close();
        StringBuffer ancestors = new StringBuffer();
        if (ids == null) {
            return ancestors.toString();
        }
        collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        Filter filter = collection.addFilter("path <= :ancestors");
        filter.set("ancestors", (Object)ids);
        filter = collection.addFilter("path = substr(:path, 1, length(path))");
        filter.set("path", (Object)ids);
        collection.addOrder("path");
        while (collection.next()) {
            ancestors.append("/" + collection.get("name"));
        }
        return ancestors.toString();
    }

    protected static int isValidPath(String path) {
        if (path.length() == 0) {
            return 1;
        }
        if (path.charAt(0) == SEPARATOR_CHAR) {
            return 2;
        }
        if (path.charAt(path.length() - 1) == SEPARATOR_CHAR) {
            return 3;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (name.length() == 0) {
                return 1;
            }
            int nec = ResourceImpl.isValidName(name);
            if (nec == 0) continue;
            return nec;
        }
        return 0;
    }

    protected static boolean isAbsolutePath(String path) {
        if (path.length() == 0) {
            return false;
        }
        return path.trim().charAt(0) == SEPARATOR_CHAR && 0 == ResourceImpl.isValidPath(path.substring(1));
    }

    protected static int isValidName(String name) {
        Perl5Util util = new Perl5Util();
        String INVALID_START_PATTERN = "/^[.]+/";
        if (util.match(INVALID_START_PATTERN, name)) {
            return 5;
        }
        String INVALID_NAME_PATTERN = "/[^a-zA-Z0-9\\_\\.\\-\\ ]+/";
        if (util.match(INVALID_NAME_PATTERN, name)) {
            return 4;
        }
        return 0;
    }

    public static String getCanonicalPath(String path) throws InvalidNameException {
        int length;
        int end;
        String errMsg = "Unable to construct canonical path for: ";
        if (null == path) {
            throw new InvalidNameException(errMsg + path);
        }
        int start = path.charAt(0) == SEPARATOR_CHAR ? 1 : 0;
        String canonicalPath = path.substring(start, end = path.charAt((length = path.length()) - 1) == SEPARATOR_CHAR ? length - 1 : length);
        int pec = ResourceImpl.isValidPath(canonicalPath);
        if (pec != 0) {
            throw new InvalidNameException(pec);
        }
        return canonicalPath;
    }

    public BigDecimal getResourceID() {
        return this.getID();
    }

    public BigDecimal getResourceID(String path) throws DataObjectNotFoundException, InvalidNameException {
        int pec = ResourceImpl.isValidPath(path);
        if (pec != 0) {
            throw new InvalidNameException(pec);
        }
        String absPath = this.getPath() + "/" + path;
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.docrepo.getResourceByPath");
        query.setParameter("targetPath", (Object)absPath);
        if (query.next()) {
            BigDecimal id = (BigDecimal)query.get("id");
            query.close();
            return id;
        }
        throw new DataObjectNotFoundException("No resource with path " + absPath);
    }

    protected Vector getPropertyNames() {
        Vector<String> names = new Vector<String>();
        names.addElement("name");
        names.addElement("description");
        names.addElement("isFolder");
        return names;
    }

    public Date getLastModifiedDate() {
        Date date = (Date)this.get("lastModifiedDate");
        return date;
    }

    public void setLastModifiedDate(Date date) {
        this.set("lastModifiedDate", date);
    }

    public Date getCreationDate() {
        Date date = (Date)this.get("creationDate");
        return date;
    }

    public void setCreationDate(Date date) {
        this.set("creationDate", date);
    }

    public User getCreationUser() {
        DataObject dobj = (DataObject)this.get("creationUser");
        if (dobj == null) {
            throw new DataObjectNotFoundException("Creation User not found");
        }
        User user = (User)DomainObjectFactory.newInstance((DataObject)dobj);
        return user;
    }

    public void setCreationUser(User user) {
        this.set("creationUser", user);
    }

    public User getLastModifiedUser() {
        DataObject dobj = (DataObject)this.get("lastModifiedUser");
        if (dobj == null) {
            throw new DataObjectNotFoundException("Last User not found");
        }
        User user = (User)DomainObjectFactory.newInstance((DataObject)dobj);
        return user;
    }

    public void setLastModifiedUser(User user) {
        this.set("lastModifiedUser", user);
    }

    public String getCreationIP() {
        String ip = (String)this.get("creationIP");
        return ip;
    }

    public void setCreationIP() {
        HttpServletRequest req = Web.getRequest();
        String ip = req == null ? "127.0.0.1" : req.getRemoteAddr();
        this.set("creationIP", ip);
    }

    public String getLastModifiedIP() {
        String ip = (String)this.get("lastModifiedIP");
        return ip;
    }

    public void setLastModifiedIP() {
        HttpServletRequest req = Web.getRequest();
        String ip = req == null ? "127.0.0.1" : req.getRemoteAddr();
        this.set("lastModifiedIP", ip);
    }

    protected static void copy(ResourceImpl src, ResourceImpl dest) {
        Vector props = src.getPropertyNames();
        for (int i = 0; i < props.size(); ++i) {
            String name = (String)props.elementAt(i);
            dest.set(name, src.get(name));
        }
    }

    @Override
    public Resource copyTo(Resource parent) {
        return this.copyTo(this.getName(), parent);
    }

    @Override
    public Resource copyTo(String name) {
        return this.copyTo(name, this.getParent());
    }

    @Override
    public abstract Resource copyTo(String var1, Resource var2);
}

