/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.ResourceImpl;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.DestinationFolderForm;
import com.arsdigita.docrepo.ui.FileUploadForm;
import com.arsdigita.docrepo.ui.FolderContentsTableForm;
import com.arsdigita.docrepo.ui.FolderCreateForm;
import com.arsdigita.docrepo.ui.FolderNamePrintListener;
import com.arsdigita.docrepo.ui.RepositoriesSuperTreeModel;
import com.arsdigita.docrepo.ui.SuperTree;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;

class BrowsePane
extends ModalContainer
implements DRConstants,
ChangeListener,
RequestListener {
    private Component m_folderContent;
    private Component m_destinationFolderPanel;
    private Component m_newFileForm;
    private Component m_newFolderForm;
    private Component m_errorMsgPanel;
    private DestinationFolderForm m_destinationFolderForm;
    private ErrorMessageLabel m_errorMsgLabel;
    private Container m_mainBrowseContainer;
    private Tree m_tree;
    private BigDecimalParameter m_rootFolderIdParam = new BigDecimalParameter("r_id");
    private BigDecimalParameter m_selFolderIdParam = new BigDecimalParameter("f_id");
    private BigDecimalParameter m_fileIdParam = new BigDecimalParameter("d_id");
    private StringParameter m_rootAddDocParam = new StringParameter("root_add_doc");

    public BrowsePane() {
        this.m_mainBrowseContainer = new BoxPanel();
        this.m_mainBrowseContainer.setClassAttr("sidebarNavPanel");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        this.m_tree = new SuperTree(new RepositoriesSuperTreeModel());
        this.m_tree.addChangeListener((ChangeListener)this);
        leftSide.add((Component)this.m_tree);
        this.m_mainBrowseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        this.m_folderContent = this.makeContentPanel(rightSide);
        this.m_mainBrowseContainer.add((Component)rightSide);
        this.add((Component)this.m_mainBrowseContainer);
        this.m_newFileForm = this.makeFileUploadForm();
        this.add(this.m_newFileForm);
        this.m_newFolderForm = this.makeFolderCreateForm();
        this.add(this.m_newFolderForm);
        this.m_destinationFolderPanel = this.makeExpandFolderPanel();
        this.add(this.m_destinationFolderPanel);
        this.m_errorMsgPanel = this.makeErrorMsgPanel();
        this.add(this.m_errorMsgPanel);
    }

    public void register(Page p) {
        p.addGlobalStateParam((ParameterModel)this.m_rootFolderIdParam);
        p.addGlobalStateParam((ParameterModel)this.m_selFolderIdParam);
        p.addGlobalStateParam((ParameterModel)this.m_rootAddDocParam);
        p.addGlobalStateParam((ParameterModel)this.m_fileIdParam);
        p.addRequestListener((RequestListener)this);
        super.register(p);
    }

    public void pageRequested(RequestEvent e) {
        PageState state = e.getPageState();
        BigDecimal fid = (BigDecimal)state.getValue((ParameterModel)this.m_fileIdParam);
        boolean display = false;
        String key = (String)this.m_tree.getSelectedKey(state);
        if (key == null) {
            key = DRUtils.getRootFolder(state).getID().toString();
            this.m_tree.setSelectedKey(state, (Object)key);
            display = true;
        }
        if (fid != null) {
            try {
                File file = new File(fid);
                ResourceImpl parent = (ResourceImpl)file.getParent();
                key = parent.getID().toString();
                while (!parent.isRoot()) {
                    parent = (ResourceImpl)parent.getParent();
                    this.m_tree.expand(parent.getID().toString(), state);
                }
            }
            catch (DataObjectNotFoundException exc) {
                exc.printStackTrace();
            }
            this.m_tree.setSelectedKey(state, (Object)key);
            state.setValue((ParameterModel)this.m_fileIdParam, null);
        }
        this.m_tree.expand(key, state);
        if (display) {
            if ("t".equalsIgnoreCase((String)state.getValue((ParameterModel)this.m_rootAddDocParam))) {
                this.displayFileUpload(state);
            } else {
                this.displayFolderContentPanel(state);
            }
        }
    }

    public BigDecimal getFolderID(PageState state) {
        return new BigDecimal((String)this.m_tree.getSelectedKey(state));
    }

    public void stateChanged(ChangeEvent e) {
        PageState state = e.getPageState();
        this.displayFolderContentPanel(state);
    }

    private Component makeContentPanel(SegmentedPanel main) {
        Label folder_info_header = new Label(new GlobalizedMessage("ui.folder.content.header", "com.arsdigita.docrepo.DRResources"));
        folder_info_header.addPrintListener((PrintListener)new FolderNamePrintListener(this.m_tree));
        ActionLink newFileLink = new ActionLink((Component)new Label(FOLDER_NEW_FILE_LINK));
        newFileLink.setClassAttr("actionLink");
        ActionLink newFolderLink = new ActionLink((Component)new Label(FOLDER_NEW_FOLDER_LINK));
        newFolderLink.setClassAttr("actionLink");
        newFileLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowsePane.this.displayFileUpload(e.getPageState());
            }
        });
        newFolderLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowsePane.this.displayFolderCreate(e.getPageState());
            }
        });
        GridPanel folderGrid = new GridPanel(1);
        SimpleContainer pane = new SimpleContainer();
        pane.add((Component)newFileLink);
        pane.add((Component)new Label("        "));
        pane.add((Component)newFolderLink);
        folderGrid.add((Component)pane, 36);
        folderGrid.add((Component)new FolderContentsTableForm(this, this.m_tree), 33);
        return main.addSegment((Component)folder_info_header, (Component)folderGrid);
    }

    private Component makeFileUploadForm() {
        GridPanel gridPanel = new GridPanel(1);
        Label fileUploadFormHeaderLabel = new Label(new GlobalizedMessage("ui.file.upload.header", "com.arsdigita.docrepo.DRResources"));
        fileUploadFormHeaderLabel.addPrintListener((PrintListener)new FolderNamePrintListener(this.m_tree));
        gridPanel.add((Component)fileUploadFormHeaderLabel);
        gridPanel.add((Component)new FileUploadForm(this, this.m_tree));
        return gridPanel;
    }

    private Component makeFolderCreateForm() {
        GridPanel gridPanel = new GridPanel(1);
        Label folderCreateFormHeaderLabel = new Label(new GlobalizedMessage("ui.folder.create.header", "com.arsdigita.docrepo.DRResources"));
        folderCreateFormHeaderLabel.addPrintListener((PrintListener)new FolderNamePrintListener(this.m_tree));
        gridPanel.add((Component)folderCreateFormHeaderLabel);
        gridPanel.add((Component)new FolderCreateForm(this, this.m_tree));
        return gridPanel;
    }

    private Component makeExpandFolderPanel() {
        GridPanel gridPanel = new GridPanel(1);
        gridPanel.add((Component)DESTINATION_FOLDER_PANEL_HEADER);
        this.m_destinationFolderForm = new DestinationFolderForm(this);
        gridPanel.add((Component)this.m_destinationFolderForm);
        return gridPanel;
    }

    private Component makeErrorMsgPanel() {
        ColumnPanel c = new ColumnPanel(1);
        this.m_errorMsgLabel = new ErrorMessageLabel();
        c.add((Component)this.m_errorMsgLabel);
        ActionLink link = new ActionLink((Component)ACTION_ERROR_CONTINUE);
        link.setClassAttr("actionLink");
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowsePane.this.displayFolderContentPanel(e.getPageState());
            }
        });
        c.add((Component)link);
        return c;
    }

    public void displayFileUpload(PageState state) {
        this.setVisibleComponent(state, this.m_newFileForm);
    }

    public void displayFolderCreate(PageState state) {
        this.setVisibleComponent(state, this.m_newFolderForm);
    }

    public void displayFolderContentPanel(PageState state) {
        this.setVisibleComponent(state, (Component)this.m_mainBrowseContainer);
    }

    public void displayDestinationFolderPanel(PageState state, Object[] resourceList, boolean isMove) {
        this.setVisibleComponent(state, this.m_destinationFolderPanel);
        this.m_destinationFolderForm.setResourceList(state, resourceList);
        if (isMove) {
            this.m_destinationFolderForm.setMove(state);
        } else {
            this.m_destinationFolderForm.setCopy(state);
        }
    }

    public void displayErrorMsgPanel(PageState state, String action, ArrayList list) {
        this.m_errorMsgLabel.setMessages(state, action, list);
        this.setVisibleComponent(state, this.m_errorMsgPanel);
    }

    private static class DirLinkRenderer
    implements ListCellRenderer {
        private DirLinkRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            Link link = new Link((String)value, "?" + DRConstants.SEL_FOLDER_ID_PARAM.getName() + "=" + key);
            return link;
        }
    }

    private static class ErrorMessageLabel
    extends SimpleComponent
    implements DRConstants {
        private RequestLocal m_msgs = new RequestLocal();
        private RequestLocal m_action = new RequestLocal();

        public void setMessages(PageState state, String action, ArrayList msgs) {
            this.m_action.set(state, (Object)action);
            this.m_msgs.set(state, (Object)msgs);
        }

        public void generateXML(PageState state, Element parent) {
            Element element = parent.newChildElement("docs:error-label", "http://www.arsdigita.com/docs-ui/1.0");
            element.addAttribute("action", (String)this.m_action.get(state));
            ArrayList list = (ArrayList)this.m_msgs.get(state);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Element item = element.newChildElement("docs:item", "http://www.arsdigita.com/docs-ui/1.0");
                    item.addAttribute("name", (String)list.get(i));
                }
            }
        }
    }
}

