/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormValidationException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.Repository;
import com.arsdigita.docrepo.ResourceImpl;
import com.arsdigita.docrepo.Util;
import com.arsdigita.docrepo.ui.BrowsePane;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class DestinationFolderForm
extends Form
implements FormInitListener,
FormProcessListener,
DRConstants {
    private Hidden m_resourceList;
    private ExpandedFolderTree m_radioGroup;
    private Submit m_copySubmit;
    private Submit m_moveSubmit;
    private BrowsePane m_parent;

    public DestinationFolderForm(BrowsePane parent) {
        super("Destination-Folder", (Container)new ColumnPanel(1));
        this.m_parent = parent;
        this.m_resourceList = new Hidden((ParameterModel)new ArrayParameter("resourceList"));
        this.add((Component)this.m_resourceList);
        this.m_radioGroup = new ExpandedFolderTree();
        this.add((Component)this.m_radioGroup);
        this.m_copySubmit = new Submit("Copy");
        this.add((Component)this.m_copySubmit);
        this.m_moveSubmit = new Submit("Move");
        this.add((Component)this.m_moveSubmit);
        this.addInitListener(this);
        this.addProcessListener(this);
    }

    public void generateXML(PageState ps, Element elt) {
        this.doSubmit(ps);
        super.generateXML(ps, elt);
    }

    private void doSubmit(PageState ps) {
        Object[] list = (Object[])this.m_resourceList.getValue(ps);
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < list.length; ++i) {
            l.add(list[i]);
        }
        this.m_radioGroup.setSources(ps, l);
    }

    public void setResourceList(PageState state, Object[] list) {
        this.m_resourceList.setValue(state, (Object)list);
    }

    public void setCopy(PageState state) {
        state.setVisible((Component)this.m_moveSubmit, false);
        state.setVisible((Component)this.m_copySubmit, true);
    }

    public void setMove(PageState state) {
        state.setVisible((Component)this.m_moveSubmit, true);
        state.setVisible((Component)this.m_copySubmit, false);
    }

    public void init(FormSectionEvent e) {
        if (Kernel.getContext().getParty() == null) {
            Util.redirectToLoginPage(e.getPageState());
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        boolean isCopy = true;
        boolean isError = false;
        ArrayList<String> msgList = new ArrayList<String>();
        if (this.m_moveSubmit.isSelected(state)) {
            isCopy = false;
        }
        try {
            String parent = (String)this.m_radioGroup.getValue(state);
            if (parent == null) {
                throw new FormValidationException("Please choose a destination.");
            }
            OID parentOID = new OID("com.arsdigita.docrepo.ResourceImpl", (Object)new BigDecimal(parent));
            Folder parentResource = (Folder)DomainObjectFactory.newInstance((OID)parentOID);
            String[] resourceIDs = (String[])this.m_resourceList.getValue(state);
            for (int i = 0; i < resourceIDs.length; ++i) {
                OID oid = new OID("com.arsdigita.docrepo.ResourceImpl", (Object)new BigDecimal(resourceIDs[i]));
                ResourceImpl resource = null;
                try {
                    resource = (ResourceImpl)DomainObjectFactory.newInstance((OID)oid);
                    if (resource.isFile()) {
                        resource = (File)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.docrepo.File", (Object)new BigDecimal(resourceIDs[i])));
                    }
                    if (isCopy) {
                        resource.copyTo(parentResource);
                        continue;
                    }
                    resource.setParent(parentResource);
                    resource.save();
                    continue;
                }
                catch (PersistenceException exc) {
                    isError = true;
                    if (resource == null) continue;
                    msgList.add(resource.getName());
                    continue;
                }
                catch (DataObjectNotFoundException exc) {
                    isError = true;
                    if (resource == null) continue;
                    msgList.add(resource.getName());
                }
            }
        }
        catch (DataObjectNotFoundException exc) {
            isError = true;
        }
        if (isError) {
            String action = null;
            action = isCopy ? "copy" : "move";
            this.m_parent.displayErrorMsgPanel(state, action, msgList);
        } else {
            this.m_parent.displayFolderContentPanel(state);
        }
    }

    private class ExpandedFolderTree
    extends RadioGroup {
        private RequestLocal m_srcResources;

        public ExpandedFolderTree() {
            super("resourceID");
            this.m_srcResources = new RequestLocal();
        }

        public void setSources(PageState state, ArrayList list) {
            this.m_srcResources.set(state, (Object)list);
        }

        public void generateXML(PageState state, Element parent) {
            Element treeElement = parent.newChildElement("bebop:tree", "http://www.arsdigita.com/bebop/1.0");
            BigDecimal sourceFolderID = DestinationFolderForm.this.m_parent.getFolderID(state);
            HashMap<BigDecimal, Element> map = new HashMap<BigDecimal, Element>();
            map.put(new BigDecimal("-1"), treeElement);
            Session session = SessionManager.getSession();
            DataQuery query = session.retrieveQuery("com.arsdigita.docrepo.listDestinationFolders");
            Repository repository = (Repository)Web.getContext().getApplication();
            BigDecimal rootID = repository.getRoot().getID();
            String path = repository.getRoot().getPath();
            query.setParameter("rootID", (Object)rootID);
            query.setParameter("rootPath", (Object)path);
            ArrayList resources = (ArrayList)this.m_srcResources.get(state);
            if (resources != null) {
                DataCollection collection = session.retrieve("com.arsdigita.docrepo.ResourceImpl");
                Iterator iterator = resources.iterator();
                while (iterator.hasNext()) {
                    collection.addEqualsFilter("id", iterator.next());
                }
                if (resources.size() > 0) {
                    int item = 0;
                    while (collection.next()) {
                        Filter filter = query.addFilter(" not path like :item" + item);
                        filter.set("item" + item, collection.get("path"));
                    }
                }
            }
            query.addOrder("path");
            query.addOrder("name");
            while (query.next()) {
                boolean isSelectable;
                BigDecimal parentID = (BigDecimal)query.get("parentID");
                BigDecimal resourceID = (BigDecimal)query.get("resourceID");
                String name = null;
                name = resourceID.equals(rootID) ? "Documents" : (String)query.get("name");
                Element p = (Element)map.get(parentID);
                boolean bl = isSelectable = !resourceID.equals(sourceFolderID);
                if (p == null) continue;
                map.put(resourceID, this.createNode(state, p, isSelectable, resourceID, name));
            }
        }

        private Element createNode(PageState state, Element parent, boolean makeSelectable, BigDecimal id, String name) {
            Element element = parent.newChildElement("bebop:t_node", "http://www.arsdigita.com/bebop/1.0");
            element.addAttribute("indentStart", "t");
            element.addAttribute("indentClose", "t");
            if (makeSelectable) {
                element.addAttribute("resourceID", id.toString());
                element.addAttribute("radioGroup", "t");
                element.addAttribute("radioGroupName", this.getName());
            } else {
                element.addAttribute("radioGroup", "f");
            }
            Label label = new Label(name);
            label.generateXML(state, element);
            return element;
        }
    }
}

