/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.docrepo.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.web.Application;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

class DocrepoBasePage
extends Page {
    private final Container m_global;
    private final Container m_header;
    private final Container m_body;
    private final Container m_footer;
    private IntegerParameter m_selected = new IntegerParameter("m");
    public static final String DOC_GLOBAL_ELEMENT = "docs:global";
    public static final String DOC_HEADER_ELEMENT = "docs:header";
    public static final String DOC_BODY_ELEMENT = "docs:body";
    public static final String DOC_FOOTER_ELEMENT = "docs:footer";
    public static final String DOC_XML_NS = "http://www.redhat.com/docs/1.0";
    private static final Logger s_log = Logger.getLogger(DocrepoBasePage.class);
    private String m_view;
    private Link m_viewLink;
    private boolean CHECK_PERMISSION = true;

    public DocrepoBasePage() {
        this(null);
    }

    public DocrepoBasePage(String view) {
        super(new Label(), (Container)new SimpleContainer());
        this.setClassAttr("DOCS");
        this.m_panel = new Panel();
        this.addGlobalStateParam((ParameterModel)this.m_selected);
        this.m_global = new SimpleContainer(DOC_GLOBAL_ELEMENT, DOC_XML_NS);
        this.m_header = new SimpleContainer(DOC_HEADER_ELEMENT, DOC_XML_NS);
        this.m_body = new SimpleContainer(DOC_BODY_ELEMENT, DOC_XML_NS);
        this.m_footer = new SimpleContainer(DOC_FOOTER_ELEMENT, DOC_XML_NS);
        super.add((Component)this.m_global);
        super.add((Component)this.m_header);
        super.add((Component)this.m_body);
        super.add((Component)this.m_footer);
        this.m_view = view;
    }

    public void lock() {
        this.buildPage();
        super.lock();
    }

    protected final void buildPage() {
        this.buildTitle();
        this.buildGlobal(this.getGlobal());
        this.buildHeader(this.getHeader());
        this.buildBody(this.getBody());
        this.buildFooter(this.getFooter());
    }

    protected void buildTitle() {
        if (this.m_view != null && this.m_view.equals("admin")) {
            class ApplicationAdminLabelPrinter
            implements PrintListener {
                ApplicationAdminLabelPrinter() {
                }

                public void prepare(PrintEvent e) {
                    Label targetLabel = (Label)e.getTarget();
                    PageState pageState = e.getPageState();
                    Application application = Web.getContext().getApplication();
                    Assert.exists((Object)application, Application.class);
                    targetLabel.setLabel(application.getTitle() + " Administration");
                }
            }
            this.setTitle(new Label((PrintListener)new ApplicationAdminLabelPrinter()));
        } else {
            this.setTitle(new Label((PrintListener)new CurrentApplicationLabelPrinter()));
        }
    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.setClassAttr("portalNavbar");
        navbar.add((Component)new Link((PrintListener)new ParentApplicationLinkPrinter()));
        navbar.add((Component)new Link((PrintListener)new CurrentApplicationLinkPrinter()));
        this.getHeader().add((Component)navbar);
    }

    protected void buildGlobal(Container global) {
        Link link = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.sign_out")), "/register/logout");
        link.setClassAttr("signoutLink");
        this.getGlobal().add((Component)link);
    }

    protected void buildHeader(Container header) {
        if (this.m_view != null) {
            if (this.m_view.equals("user")) {
                this.m_viewLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.doc.ui.admin_view")), "./admin/index.jsp"){

                    public boolean isVisible(PageState ps) {
                        return DocrepoBasePage.this.userIsAdmin(ps);
                    }
                };
            } else if (this.m_view.equals("admin")) {
                this.m_viewLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.doc.ui.user_view")), "../index.jsp");
            }
        }
        if (this.m_viewLink != null) {
            this.m_viewLink.setClassAttr("portalControl");
            header.add((Component)this.m_viewLink);
        }
    }

    protected void buildBody(Container body) {
    }

    protected void buildFooter(Container footer) {
    }

    public void goModal(PageState ps, Component c) {
        Component old = this.getSelected(ps);
        if (old != null) {
            old.setVisible(ps, false);
        }
        c.setVisible(ps, true);
        this.setSelected(ps, c);
    }

    private Component getSelected(PageState ps) {
        Integer stateIndex = (Integer)ps.getValue((ParameterModel)this.m_selected);
        Component c = null;
        if (stateIndex != null) {
            c = this.getComponent(stateIndex);
        }
        return c;
    }

    private void setSelected(PageState ps, Component c) {
        if (c == null) {
            ps.setValue((ParameterModel)this.m_selected, null);
        } else {
            ps.setValue((ParameterModel)this.m_selected, (Object)new Integer(this.stateIndex(c)));
        }
    }

    public void goUnmodal(PageState ps) {
        Component old = this.getSelected(ps);
        if (old != null) {
            old.setVisible(ps, false);
        }
        this.setSelected(ps, null);
    }

    private boolean userIsAdmin(PageState ps) {
        PermissionDescriptor permDescriptor = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)Web.getContext().getApplication(), Kernel.getContext().getParty());
        return PermissionService.checkPermission((PermissionDescriptor)permDescriptor);
    }

    public void add(Component pc) {
        Assert.isUnlocked((Lockable)this);
        this.m_body.add(pc);
    }

    public Container getGlobal() {
        return this.m_global;
    }

    public Container getHeader() {
        return this.m_header;
    }

    public Container getBody() {
        return this.m_body;
    }

    public Container getFooter() {
        return this.m_footer;
    }

    protected class CurrentApplicationLabelPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Label label = (Label)e.getTarget();
            PageState pageState = e.getPageState();
            Application app = Web.getContext().getApplication();
            Assert.exists((Object)app, Application.class);
            label.setLabel(app.getTitle());
        }
    }

    protected class ParentApplicationLinkPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            PageState pageState = e.getPageState();
            Application app = Web.getContext().getApplication();
            Assert.exists((Object)app, Application.class);
            Application parent = app.getParentApplication();
            if (parent != null) {
                link.setChild((Component)new Label(parent.getTitle()));
                link.setTarget(parent.getPath());
            } else {
                link.setChild((Component)new Label("/"));
                link.setTarget(URL.root().toString());
            }
        }
    }

    protected class CurrentApplicationLinkPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            PageState pageState = e.getPageState();
            Application app = Web.getContext().getApplication();
            Assert.exists((Object)app, Application.class);
            link.setChild((Component)new Label(app.getTitle()));
            link.setTarget(app.getPath());
        }
    }

    private class Panel
    extends SimpleContainer {
        private Panel() {
        }

        public void generateXML(PageState ps, Element p) {
            Component selected = DocrepoBasePage.this.getSelected(ps);
            if (selected == null) {
                super.generateXML(ps, p);
            } else {
                SimpleContainer fakeBody = new SimpleContainer(DocrepoBasePage.DOC_BODY_ELEMENT, DocrepoBasePage.DOC_XML_NS);
                fakeBody.add(selected);
                Element parent = this.generateParent(p);
                DocrepoBasePage.this.m_header.generateXML(ps, parent);
                fakeBody.generateXML(ps, parent);
                DocrepoBasePage.this.m_footer.generateXML(ps, parent);
            }
        }
    }
}

