/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.FileRevisionsTable;
import com.arsdigita.domain.DataObjectNotFoundException;
import java.math.BigDecimal;

class FileInfoHistoryPane
extends SimpleContainer
implements DRConstants {
    private Component m_history;
    private RequestLocal m_file = new RequestLocal(){

        protected Object initialValue(PageState state) {
            BigDecimal id = (BigDecimal)state.getValue((ParameterModel)DRConstants.FILE_ID_PARAM);
            File file = null;
            try {
                file = new File(id);
            }
            catch (DataObjectNotFoundException nfe) {
                // empty catch block
            }
            return file;
        }
    };

    public FileInfoHistoryPane() {
        SegmentedPanel main = new SegmentedPanel();
        main.setClassAttr("main");
        this.m_history = this.makeHistoryPane(main);
        this.add((Component)main);
    }

    private Component makeHistoryPane(SegmentedPanel panel) {
        return panel.addSegment((Component)FILE_REVISION_HISTORY_HEADER, (Component)new FileRevisionsTable(this));
    }

    public void register(Page p) {
        p.addGlobalStateParam((ParameterModel)FILE_ID_PARAM);
        super.register(p);
    }

    File getFile(PageState state) {
        return (File)this.m_file.get(state);
    }
}

